/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Nov 19, 2003
 * Time: 1:16:43 PM
 * To change this template use Options | File Templates.
 */
package net.web;

//
// Genaral puporse IP:port forwarder device
// (c) RJHM van den Bergh/comweb.nl
// support@comweb.nl
//
// DISCLAIMER: The use of this software is at your own risk.
//
// Purpose to change it later to a conditonal tunneling device
// I&#39;ve configured a local http server to listen to port 80 except on one IP address.
// I run this port forwarding device on this IP address.
// So for the browser it just looks if he connects to this http server.
//
// Later on I can add some heuristic algoritme to determine so an applet can request a http tunnel.
// For example a chat applet.
// This way it can bypass proxy firewalls.
//
// COPYRIGHT:
// Freeware but at own risk.
//

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class PortMap implements Runnable {
    private static Thread serverSocketThread;
    // main thread (for ServerSocket)
    private Thread serverListenerThread;
    private Thread clientListenerThread;
    // threads used to handle seperate connections
    private Socket clientSocket;
    // socket to the client
    private Socket serverSocket;
    // socket to the server
    private InputStream clientInputStream;
    // Data from the client
    private InputStream serverInputStream;
    // Data from the server
    private OutputStream clientOutputStream;
    // Data to the client;
    private OutputStream serverOutputStream;
    // Data to the server;
    private boolean connectionErrorFlag = false;
    // flag indicating that a (connection) error occured
    private static final int S0_TIMEOUT = 25000;
    // timout 25 seconds, if nothing heard for 25 second
    //then the connection is considered lost

    private String client_line = "";
    // for debuging

    private static ServerSocket mainSocket;
    // main socket for new connections
    private static final int BACKLOG = 15;
    // Max number of waiting connections

    private static final int OUT_PORT
            = 8086;
    // sends output to port 80
    private static final String OUTPUT_ADDRESS_STRING
            = "showAndRegister.docjava.com";
    // to localhost

    private static final int INPUT_PORT = 80;
    // listens to port 80

    private static final String INPUT_ADDRESS_STRING
            = "localhost";
    // listens on this this IP
    private static InetAddress in_address;
    // filled in later with the above IP

    public PortMap() {
        super();

        // create blanc object
        serverSocketThread = new Thread(this);
        // create main thread
        serverSocketThread.start();
        // start main thread (listen for new connections)
    }

    public PortMap(Socket socket) throws IOException {
        clientSocket = socket;
        // store socket
        clientSocket.setSoTimeout(S0_TIMEOUT);
        // set timeout to prevent connections clogging up the server
        clientInputStream = clientSocket.getInputStream();
        // get the stream from the client
        clientOutputStream = clientSocket.getOutputStream();
        // get the stream to the client

        serverSocket = new Socket(
                InetAddress.getByName(OUTPUT_ADDRESS_STRING),
                OUT_PORT);
        // create socket to the server
        serverSocket.setSoTimeout(S0_TIMEOUT);
        // set timeout to prevent connections clogging up
        //the server
        serverInputStream = serverSocket.getInputStream();
        // get the stream from the server
        serverOutputStream = serverSocket.getOutputStream();
        // get the stream to the server

        clientListenerThread = new Thread(this);
        // create thread that handles client data
        serverListenerThread = new Thread(this);
        // create thread that handles server data
        clientListenerThread.start();
        // start client thread
        serverListenerThread.start();
        // start server thread
    }

    public static void main(String arg[]) {
        try {
            net.proxy.Proxy.setSoeProxy();
            in_address = InetAddress.getByName(INPUT_ADDRESS_STRING); 			// fill in the IP number where to listen to.
            mainSocket = new ServerSocket(INPUT_PORT, BACKLOG, in_address);   // create the server socket
            new PortMap(); 											// create (and start) the porter application
        } catch (Exception e) {
            System.out.println("Oops couldnt start");				// Perhaps a bind exception if IP:port already in use.
            e.printStackTrace();									// print some more debuging information.
        }
    }

    public void run() {
        while (Thread.currentThread() == serverSocketThread) 			// loop the main thread for ever (if it is the main thread)
        {
            try {
                new PortMap(mainSocket.accept());			// wait for incomming connections and then start an new porter object (with its own threads) to handle the connection further
            } catch (Exception e) {
                System.out.println("Oops error.");		// unwanted error, perhaps caused by the client.
                e.printStackTrace();					// print more debugging information
            }
            Thread.yield();								// always yield at a while loop so it can&#39;t consume all processor power
        }

        while (Thread.currentThread() == clientListenerThread) // if its the thread listening to a client the loop it
        {
            byte[] data = new byte[1];
            try {
                data[0] = (byte) clientInputStream.read();

/*
//
// Conditional forwarding can be added here
// It can be done with some heuristic algorithm
//
*/

/*
//
// To output client data to the console
// Note this enormously slows down the forwarding !!
//
if (data[0]!=10) // \n in default encoding
{
	client_line=client_line+new String(data);
} else
{
	System.out.println("Client: "+client_line);
	client_line="";
}
//
// or easier System.out.write(data[0]);
//
*/

                serverOutputStream.write(data[0]);
// forward the data to the server
            } catch (InterruptedIOException ie)
// catch a timeout exception on the client side
            {
                System.out.println("Client time out!!");
// says enough I think, not that this will not be uncommen
                connectionErrorFlag = true;
// set flag to indicate that an error occured
            } catch (Exception e) {
                System.out.println("Oops Error client_listener");	// Catch any other error
                e.printStackTrace();								// output additional debuging info but note that this error is most likely related to some network thing so not very uncommen
                connectionErrorFlag = true;									// set error flag so we know forwardign isn&#39;t usefull anymore.
            } finally {
                Thread.yield();										// always yield a while loop so it never consumes all processor power
                if (connectionErrorFlag) {
                    close();
                    return;
                }
 // check for error and if needed call the close() method of this class instance
            }
        }

        while (Thread.currentThread() == serverListenerThread)
                // if it is the thread listening the server then loop it
        {
            byte data;
            // variable to store data into (byte data)
            try {
                data = (byte) serverInputStream.read();
                // get (response) data from the server
                clientOutputStream.write(data);
                // forward it to the client
            } catch (InterruptedIOException ie)

// catch any timeouts from the server
//(prevents server from being clogged with unused connections)
            {
                System.out.println("Server time out!!");			// says enough
                connectionErrorFlag = true;									// set error flag to indicate that forwarding isn&#39;t useful anymore
            } catch (Exception e) {
                System.out.println("Oops Error Server_listener");	// Says enough some error occured which isn&#39;t uncommen esspecially when its an IO erro
                e.printStackTrace();								// output additional debugging information
                connectionErrorFlag = true;									// set error flag
            } finally {
                Thread.yield();										// allways yield a while loop, to prevent it using up all processor power
                if (connectionErrorFlag) {
                    close();
                    return;
                }				// if an error has ocurred call the close() method from this class instance
            }
        }
    }

    private void close() {
        try {
            if (clientInputStream != null) 									// check if the stream coming from the the client does exist
                closeStreamFromClient();
        } catch (IOException e) {
            System.out.println("Couldn&#39;t close stream from client");	// Wierd thing the stream wouldn&#39;t close.
            e.printStackTrace();										// output additional debugging info
        }

        try {
            if (serverInputStream != null)										// check if the stream coming from the server exist
                closeStreamToServer();
        } catch (IOException e) {
            System.out.println("Couldnt close stream to server");		// Wierd thing, the stream wouldn&#39;t close
            e.printStackTrace();										// output additional debuging information.
        }

        try {
            if (clientSocket != null)									// check if the socket to the client exist
                closeSocketToClient();
        } catch (IOException e) {
            System.out.println("Couldn&#39;t close socket to client.");		// A wierd error occured we couldn&#39;t close the socket to the client
            e.printStackTrace();										// Output additonal debugging information.
        }

        try {
            closeSocketToServer();
        } catch (IOException e) {
            System.out.println("Couldn&#39;t close socket to server.");		// Wierd couldn&#39;t close the socket to the server
            e.printStackTrace();										// Output additional debugging information
        }
    }

    private void closeSocketToServer() throws IOException {
        if (serverSocket != null) {								// check if the server socket does exist
            System.out.println("Closing socket to server.");		// Say that we are going to close the socket to the server
            serverSocket.close();									// close the socket to the server
        }
    }

    private void closeSocketToClient() throws IOException {
        System.out.println("Closing socket to client.");		// say that we are going to close the socket to the client
        clientSocket.close();									// close the socket to the client.
    }

    private void closeStreamToServer() throws IOException {
        System.out.println("Closing stream to server.");		// Say that we are going to close the stream to the server.
        serverInputStream.close();										// close the stream coming from the server
        clientOutputStream.flush();										// Send any pending data from the client to the server
    }

    private void closeStreamFromClient() throws IOException {
        System.out.println("Closing stream from client.");	// sya that we are going to close the stream from the client
        clientInputStream.close();									// closing the the stream from the client first.
        serverOutputStream.flush();									// Send any pending data that should go out to the server
    }
}
