package net.server.servlets;

/**
 *  FormCHtml Class
 */

public class FormCHtml {

    String hdr1 = "Form C: Competency - based Review Form for Basic Knowledge,"
            + " Skills and Abilities";

    String hdr2 = "Complete for all students in your class using a scale from 1 to 5:";
    String hdr3 = "see other side for explanation";


    private final String header = Html.getImage(Html.quote(
            "../images/logo.jpg"), "center")
            + Html.getBreak()
            + Html.getBold(Html.getFont(hdr1, "+2"))
            + Html.getBreak()
            + hdr2
            + Html.getUnderline(hdr3);

    private final String bodyTitle = "Basic Competencies";

    private final String bodyColumnTitle[] =
            {"S.No",
             "Students Name",
             "Analytical" + Html.getBreak() + "Skills",
             "Communic." + Html.getBreak() + "Skills",
             "Creative " + Html.getBreak() + "Problem" + Html.getBreak() + "Solving",
             "Life-Long " + Html.getBreak() + "Learning",
             "Project" + Html.getBreak() + "Management",
             "Research" + Html.getBreak() + "Skills",
             "System" + Html.getBreak() + "Thinking",
             "Teamwork"};


    private final String footer[] = {"1=Not at All ",
                                     "2=To a Limited Extent",
                                     "3=To a Satisfactory Extent",
                                     "4=To a Great Extent",
                                     "5=To a Very Great Extent"};


    private final String errorMsg[] =
            {Html.getBold(Html.getFont("Error: Unable to Locate FormC.Property File", "+2")),
             Html.getBold(Html.getFont("Error: Unable to Locate FormC.Csv File", "+2")),
             Html.getBold(Html.getFont("Error: Unknown", "+2")),
             Html.getBold(Html.getFont(" Section and Term do not exist for this class<p>Please select the Back button on your browser and try again ", "+2"))};

    private final String title = "Form C";
    private final String formMethod = "GET";

    /**
     * getFormCSheet	 Method
     *
     * @return	 	 String
     */

    private String getFormCSheet(String a[][]) {
        String s = "";

        for (int i = 0; i < a.length; i++) {
            if (i == 0) {
                s = s + "<tr align=" + Html.quote("Center") + ">";
                s = s + Html.getTd(a[i][i], (11 + ""));
            } else {
                s = s + "<tr>";

                for (int j = 0; j < a[i].length; j++) {
                    s = s + Html.getTd(a[i][j]);
                }
            }

            s = s + "</tr>\n";
        }

        return s;
    }


    /**
     * getSelectionData  Method
     *

     * @return	     String
     */

    private String getSelectionData(String[] term, String[] course,
                                    String[] section) {


        String data = "Course Number & Name"
                + Html.getComboBox("cboCourse", course)
                + Html.getBreak()
                + "Section"
                + Html.getComboBox("cboSection", section)
                + "Term"
                + Html.getComboBox("cboTerm", term);


        return Html.getTable(Html.getRow(Html.getTd(data), "Center"), "0", "100%", "Nowrap");

    }


    /**
     * getCommandSubmit Method
     *
     * @return	    String
     */

    private String getCommandSubmit() {

        return Html.getTable(
                Html.getRow(
                        Html.getTd(Html.getSubmitButton()), "Center"),
                "0", "100%", "Nowrap");

    }


    /**
     * getHeader  Method
     *
     * @return	  String
     */

    private String getHeader() {

        return Html.getTable(Html.getRow(Html.getTd(header), "Center"), "0", "100%", "Nowrap");

    }


    /**
     * getHeaderDetail  Method
     *
     * @return	     String
     */

    private String getHeaderDetail(String term, String course,
                                   String instructor) {

        String headerDetail[] = {"Course Number & Name : " + Html.getBold(course),
                                 "Instructor : " + Html.getBold(instructor),
                                 "Term : " + Html.getBold(term)};


        return Html.getTable(Html.getRow(Html.getTd(headerDetail), "Center"), "0", "100%", "Nowrap");

    }

    /**
     * getBody Method
     *
     * @return	   String
     */

    private String getBody(String[] students) {
        int noOfRows = students.length + 2;
        int noOfColumns = 10;

        String data[][] = new String[noOfRows][noOfColumns];
        String colTitle[] = bodyColumnTitle;

        for (int i = 0; i < 2; i++) {
            for (int j = 0; j < data[i].length; j++) {
                switch (i) {
                    case 0:
                        if (j == 0)
                            data[i][j] = bodyTitle;
                        else
                            data[i][j] = " ";
                        break;
                    case 1:
                        data[i][j] = colTitle[j];
                        break;
                }
            }
        }

        for (int i = 2; i < data.length; i++) {
            for (int j = 0; j < data[i].length; j++) {
                switch (j) {
                    case 0:
                        data[i][j] = (i - 1) + "";
                        break;
                    case 1:
                        data[i][j] = students[i - 2];
                        break;
                    default:
                        //deh added n/a to list of choices for professor
                        data[i][j] = Html.getComboBox(("cbo" + (i - 2) + (j - 2)), 5, "n/a");
                        break;
                }
            }
        }

        return Html.getTable(getFormCSheet(data), "1", "100%", "Nowrap");

    }


    /**
     * getBody Method
     *
     * @return	   String
     */

    private String getBody(String[] students, String[] fields,
                           String[] fValues) {
        int noOfRows = students.length + 2;
        int noOfColumns = 10;

        String data[][] = new String[noOfRows][noOfColumns];

        String colTitle[] = new String[bodyColumnTitle.length];
        colTitle = bodyColumnTitle;

        for (int i = 0; i < 2; i++) {
            for (int j = 0; j < data[i].length; j++) {
                switch (i) {
                    case 0:
                        if (j == 0)
                            data[i][j] = bodyTitle;
                        else
                            data[i][j] = " ";
                        break;
                    case 1:
                        data[i][j] = colTitle[j];
                        break;
                }
            }
        }

        for (int i = 2; i < data.length; i++) {
            for (int j = 0; j < data[i].length; j++) {
                switch (j) {
                    case 0:
                        data[i][j] = (i - 1) + "";
                        break;
                    case 1:
                        data[i][j] = students[i - 2];
                        break;
                    default:
                        for (int k = 0; k < fields.length; k++) {
                            if (fields[k].equals("cbo" + (i - 2) + (j - 2))) {
                                data[i][j] = Html.getCenter(fValues[k]);
                                break;
                            }
                        }
                        break;
                }
            }
        }

        return Html.getTable(getFormCSheet(data), "1", "100%", "Nowrap");

    }


    /**
     * getFooter Method
     *
     * @return	  String
     */

    private String getFooter() {

        return Html.getTable(Html.getRow(Html.getTd(footer), "Center"), "0", "100%", "Nowrap");

    }

    /**
     * getErrorMessage Method
     * @return	  	 String
     */

    private String getErrorMessage(int error) {

        return Html.getTable(Html.getRow(Html.getTd(errorMsg[error]),
                "Center"), "0", "100%", "Nowrap");

    }

    /**
     * Returns FormC Selection page
     *
     * @return	  String
     */

    public String formCSelect(String[] term, String[] course,
                              String[] section, String action) {

        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title)) +
                Html.getBody(
                        Html.getForm(action, formMethod,
                                Html.getBreak()
                + getHeader()
                + Html.getHiddenField("txtNextAction", "CollectData")
                + Html.getBreak()
                + getSelectionData(term, course, section)
                + Html.getBreak()
                + getCommandSubmit())
                )
                );
    }


    /**
     * Returns FormC page
     *
     * @return	  String
     */

    public String formC() {

        String students[] = {"Student0", "Student 1", "Student 2"};

        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title)) +
                Html.getBody(
                        Html.getForm("", formMethod,
                                getHeader()
                + Html.getHiddenField("txtNextAction", "DisplayData")
                + Html.getBreak()
                + getHeaderDetail("", "", "")
                + getBody(students)
                + Html.getBreak()
                + getFooter())
                )
                );
    }


    /**
     * Returns FormC page
     *
     * @return	  String
     */

    public String formC(String term, String course, String instructor,
                        String[] students, String action) {

        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title)) +
                Html.getBody(
                        Html.getForm(action, formMethod,
                                getHeader()
                + Html.getHiddenField("txtNextAction", "DisplayData")
                + Html.getBreak()
                + getHeaderDetail(term, course, instructor)
                + getBody(students)
                + Html.getBreak()
                + getCommandSubmit()
                + Html.getBreak()
                + getFooter())
                )
                );
    }

    /**
     * Returns FormC pre confirmation page
     *
     * @return	  String
     */

    public String formCData(String term, String course,
                            String instructor, String[] students,
                            String[] fields, String[] fValues) {

        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title)) +
                Html.getBody(
                        Html.getForm("", formMethod,
                                getHeader()
                + Html.getHiddenField("txtNextAction", "SQL")
                + Html.getBreak()
                + getHeaderDetail(term, course, instructor)
                + getBody(students, fields, fValues)
                + Html.getBreak()
                + getCommandSubmit()
                + Html.getBreak()
                + getFooter())
                )
                );
    }

    /**
     * Returns FormC post confirmation page
     *
     * @return    			String
     */

    public String formCUpdate() {

        String updateHdr =
                Html.getBold(Html.getFont("User Data has been written to All_forms Database", "+2"));


        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title)) +
                Html.getScript("JavaScript") +
                Html.getBody(
                        Html.getForm("", formMethod,
                                Html.getBreak()
                + getHeader()
                + Html.getBreak()
                + Html.getTable(Html.getRow(Html.getTd(updateHdr), "Center"),
                        "0", "100%", "Nowrap")
                + Html.getBreak()
                + Html.getCenter(Html.getCommandButton("cmdOK", "OK",
                        "onClick", "window.close()"))
                + Html.getBreak())
                )
                );
    }

    /**
     * Returns FormC error page
     *
     * @return	  String
     */

    public String formCError(int error) {

        return
                Html.getHtml(
                        Html.getHead(Html.getTitle(title + " " + "Error")) +
                Html.getBody(
                        Html.getForm("", formMethod,
                                Html.getBreak()
                + getErrorMessage(error))
                )
                );
    }
}