package net.server.servlets;

import java.io.BufferedReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;


/**
 *  FormCDataParser Class
 */

public class FormCDataParser implements FormCDataColumns {

    /**
     * Components
     */

    private Vector vData;
    private Vector term = new Vector();
    private Vector course = new Vector();
    private Vector section = new Vector();
    private Vector instructor = new Vector();
    private Vector courseKey = new Vector();
    private Vector courseStudents = new Vector();

    private int courseKeyIndex = 0;
    private int courseKeyIndexArray[];
    private int courseKeyIndexLength;

    /**
     * FormCDataParser() Constructor
     */

    public FormCDataParser(BufferedReader br) {
        CsvLineConsumer cv = new CsvLineConsumer(br, columnOrder);
        vData = cv.getVData();
        processData();

        //deh
        courseKeyIndexArray = new int[20];

    }

    /**
     * Returns Term Array
     *
     * @return 	  		String[]
     */

    public String[] getTerm() {
        Object[] objTerm = term.toArray();
        Arrays.sort(objTerm);

        String[] strTerm = new String[objTerm.length];

        for (int i = 0; i < strTerm.length; i++) {
            strTerm[i] = (String) objTerm[i];
        }

        return strTerm;
    }

    /**
     * Returns Courses Array
     *
     * @return 	  		String[]
     */

    public String[] getCourse() {
        Object[] objCourse = course.toArray();
        Arrays.sort(objCourse);

        String[] strCourse = new String[objCourse.length];

        for (int i = 0; i < strCourse.length; i++) {
            strCourse[i] = (String) objCourse[i];
        }

        return strCourse;
    }

    /**
     * Returns Section Array
     *
     * @return 	  		String[]
     */

    public String[] getSection() {
        Object[] objSection = section.toArray();
        Arrays.sort(objSection);

        String[] strSection = new String[objSection.length];

        for (int i = 0; i < strSection.length; i++) {
            strSection[i] = (String) objSection[i];
        }

        return strSection;
    }

    /**
     * Returns Instructor Array
     *
     * @return 	  		String[]
     */

    public String[] getInstructor() {
        Object[] objInstructor = instructor.toArray();
        Arrays.sort(objInstructor);

        String[] strInstructor = new String[objInstructor.length];

        for (int i = 0; i < strInstructor.length; i++) {
            strInstructor[i] = (String) objInstructor[i];
            System.out.println("Instr is " + strInstructor[i]);
        }

        return strInstructor;
    }

    /**
     * Returns true/false
     *
     * @return 	  				boolean
     *
     * Notes: The UserName is the Lastname and is the CourseKey against which information is built for the
     *        Survey
     */

    public boolean isCourseKeyByLoginUser(String user) {

// deh put code in here to return multiple courses
// CourseKeyIndexLength is set to -1, so the first item will be at the 0th place in the CourseKeyIndexArray
        courseKeyIndexLength = -1;

        int index = 0;
        boolean hasCourse = false;

        for (Enumeration e = (getCourseKey()).elements();
             e.hasMoreElements(); index++) {

            String strData[] = (String[]) e.nextElement();


            if ((strData[COURSE_KEY_INSTR]).regionMatches(true, 3, user, 0,
                    user.length())) {
                courseKeyIndexLength++;
                courseKeyIndexArray[courseKeyIndexLength] = index;

                hasCourse = true;
            }
        }

        return hasCourse;
    }

    /**
     * Returns true/false
     *
     * @return 	  		boolean
     */

    public boolean isCourseKey(String s) {

        int index = 0;

        for (Enumeration e = (getCourseKey()).elements();
             e.hasMoreElements(); index++) {

            String strData[] = (String[]) e.nextElement();

            if (s.equals(strData[COURSE_KEY])) {
                courseKeyIndex = index;
                return true;
            }
        }

        return false;
    }


    /**
     * Returns Course Key Index
     *
     * @return 	  		int
     */

    public int getCourseKeyIndex() {

        return courseKeyIndex;
    }

    /**
     * Returns Course Key Index Array
     *
     * @return 	  		Array of ints
     */

    public int[] getCourseKeyIndexArray() {

        return courseKeyIndexArray;
    }

    /**
     * Returns Course Key Index Array Length
     *
     * @return 	  		Length of the Array of int getCourseKeyIndexArray[]
     */

    public int getCourseKeyIndexLength() {
        System.out.println("The courseKeyIndexLength here is " + courseKeyIndexLength);
        return courseKeyIndexLength;
    }


    /**
     * Returns Course Key
     *
     * @return 	  		Vector
     */

    public Vector getCourseKey() {

        return courseKey;
    }

    /**
     * Returns Course Key value
     *
     * @return 	  		String
     */

    public String getCourseKeyValue(int keyIndex, int column) {

        String courseElements[] = (String[]) (courseKey.elementAt(keyIndex));

//    	for (int i =0; i< courseElements.length; i++){
//		System.out.println("\ncourse element is " + courseElements[i]);
//		}

        return courseElements[column];

    }

    /**
     * Returns Course Key
     *
     * @return 	  		      String
     */

    public String getCourseKeyByKey(int keyIndex) {

        return getCourseKeyValue(keyIndex, COURSE_KEY);

    }

    /**
     * Return Term of the Course
     *
     * @return 	  		      String
     */

    public String getCourseTermByKey(int keyIndex) {

        return getCourseKeyValue(keyIndex, COURSE_KEY_TERM);

    }


    /**
     * Returns Course No
     *
     * @return 	  		      String
     */

    public String getCourseNoByKey(int keyIndex) {

        return getCourseKeyValue(keyIndex, COURSE_KEY_COURSE_NO);

    }

    /**
     * Returns Course Name
     *
     * @return 	  		      String
     */

    public String getCourseNameByKey(int keyIndex) {

        return getCourseKeyValue(keyIndex, COURSE_KEY_COURSE_NAME);

    }

    /**
     * Returns Course Section
     *
     * @return 	  		      String
     */

    public String getCourseSectionByKey(int keyIndex) {

        return getCourseKeyValue(keyIndex, COURSE_KEY_SECTION);

    }

    /**
     * Returns Course Year
     *
     * @return 	  		      String
     */

    public String getCourseYearByKey(int keyIndex) {

        return getCourseKeyValue(keyIndex, COURSE_KEY_YEAR);

    }

    /**
     * Returns Course Instructor
     *
     * @return 	  		      String
     */

    public String getCourseInstructorByKey(int keyIndex) {

        return getCourseKeyValue(keyIndex, COURSE_KEY_INSTR);

    }


    /**
     * Returns Course Students
     *
     * @return 	 		Vector
     */

    public Vector getCourseStudents() {

        return courseStudents;
    }


    /**
     * Returns Course Students array
     *
     * @return 	 		     String[]
     */

    public String[] getCourseStudentsByKey(int keyIndex, int column) {

        Vector sv = (Vector) (getCourseStudents()).elementAt(keyIndex);
        String students[] = new String[sv.size()];

        int i = 0;

        for (Enumeration e = sv.elements();
             e.hasMoreElements(); i++) {

            String strObj[] = (String[]) e.nextElement();
            students[i] = strObj[column];

        }

        return students;
    }


    /**
     * Returns Course Students array
     *
     * @return 	 		     String[]
     */

    public String[] getCourseStudentsByKey(int keyIndex) {

        return getCourseStudentsByKey(keyIndex, S_STUDENT_NAME);

    }

    /**
     * Returns Course Students array
     *
     * @return 	 		       String[]
     */

    public String[] getCourseStudentsIdByKey(int keyIndex) {

        return getCourseStudentsByKey(keyIndex, S_STUDENT_ID);

    }

    /**
     * processData Method
     *
     */

    private void processData() {

        //This takes in the CSV file line by line in it's indiviual columns

        int count = vData.size();

        for (int i = 0; i < count; i++) {
            String data[] = (String[]) vData.elementAt(i);
            splitColumns(data);
        }

    }

    /**
     * splitColumns Method
     */

    private void splitColumns(String data[]) {
        StringBuffer courseBuffer = new StringBuffer();
        StringBuffer courseKeyBuffer = new StringBuffer();
        StringBuffer studentBuffer = new StringBuffer();
        String courseKeyArray[] = new String[COURSE_KEY_ARRAY_SIZE];
        String studentsArray[] = new String[STUDENTS_ARRAY_SIZE];

        addElement(term, data[IND_TERM]);

        courseBuffer.append(data[IND_COURSE_NO]);
        courseBuffer.append(" ");
        courseBuffer.append(data[IND_COURSE_NAME]);
        addElement(course, courseBuffer.toString());

        addElement(section, data[IND_SECTION]);

        courseKeyBuffer.append(data[IND_TERM]);
        courseKeyBuffer.append(" ");
        courseKeyBuffer.append(courseBuffer.toString());
        courseKeyBuffer.append(" ");
        courseKeyBuffer.append(data[IND_SECTION]);

        courseKeyArray[0] = courseKeyBuffer.toString();
        courseKeyArray[1] = data[IND_TERM];
        courseKeyArray[2] = data[IND_COURSE_NO];
        courseKeyArray[3] = data[IND_COURSE_NAME];
        courseKeyArray[4] = data[IND_SECTION];
        courseKeyArray[5] = data[IND_YEAR];
        courseKeyArray[6] = data[IND_INSTR] + data[IND_INSTR_NAME];

//		This addElement adds the courseKeyArray to courseKey if it doesn't already exist
        addElement(courseKey, courseStudents, courseKeyArray);
//		System.out.println("Course Key " + courseKey );


        studentBuffer.append(data[IND_FIRST_NAME]);
        studentBuffer.append(" ");
        studentBuffer.append(data[IND_MIDDLE_NAME]);
        studentBuffer.append(" ");
        studentBuffer.append(data[IND_LAST_NAME]);

        studentsArray[0] = data[IND_STUDENT_ID];
        studentsArray[1] = studentBuffer.toString();

//This adds	the students to the detail which is
        // the CourseKeyArray(really holds the students in here)
        addElement(courseKey, courseStudents,
                courseKeyArray, studentsArray);


    }


    /**
     * addElement	  Method
     *
     */

    private void addElement(Vector v, String data) {
        boolean dataExists = false;

        for (Enumeration e = v.elements(); e.hasMoreElements();) {
            if (data.equals(e.nextElement())) {
                dataExists = true;
                break;
            }
        }


        if (!dataExists) {
            v.addElement(data);
        }
    }

    /**
     * addElement	  Method
     *
     */

    private void addElement(Vector v, String data[]) {
        String strData[];
        boolean dataExists = false;

        for (Enumeration e = v.elements(); e.hasMoreElements();) {
            strData = (String[]) e.nextElement();
            if (data[0].equals(strData[0])) {
                dataExists = true;
                break;
            }
        }


        if (!dataExists) {
            v.addElement(data);
        }
    }


    /**
     * addElement	  Method
     *
     */

    private void addElement(Vector key, Vector detail, String data[]) {
        String strData[];
        boolean dataExists = false;

        for (Enumeration ke = key.elements(); ke.hasMoreElements();) {
            strData = (String[]) ke.nextElement();
            if (data[0].equals(strData[0])) {
                dataExists = true;
                break;
            }
        }


        if (!dataExists) {
            key.addElement(data);
            detail.addElement(new Vector());
        }
    }


    /**
     * addElement	  Method
     *
     */

    private void addElement(Vector vkey, Vector detail,
                            String skey[], String data[]) {

        String strData[];
        Enumeration ke = vkey.elements();

        for (int i = 0; ke.hasMoreElements(); i++) {
            strData = (String[]) ke.nextElement();
            if (skey[0].equals(strData[0])) {
                Vector sv = (Vector) detail.elementAt(i);
                addElement(sv, data);
                break;
            }
        }

    }

}
