package net.server.servlets;

/**
 * The Course class encapsulates the functionality
 * required to represent a course. This information
 * is retained in the member variables which store the
 * course id, the section id of the course, the term
 * and the year that the course is offered in, as well
 * as the instructor's name and all the students who are
 * registerd for this course. A constructor is provided
 * which enables the setting of all of the member variables
 * during the instantiation of the class. Additional methods
 * are provided for getting and setting these values.
 *
 * @author Robert Lysik
 * @version 1.00
 */
class Course {
    private String courseId;
    private String sectionId;
    private String term;
    private String year;
    private String instructor;
    private Student[] students;

    /**
     * This is the default constructor for the
     * Course class.
     */
    Course() {
    }

    /**
     * This Course constructor method enables the setting of all
     * of the member variables associated with a course.
     *
     * @param crs the course id
     * @param sect the section id of the course
     * @param trm the term in which the course is offered
     * @param yr the year in which the course is offered
     * @param name the name of the instructor for the course
     * @param st and array of Student objects which represent
     *               the list of all students registered for this course.
     */
    Course(String crs,
           String sect,
           String trm,
           String yr,
           String name,
           Student[] st) {
        courseId = crs;
        sectionId = sect;
        term = trm;
        year = yr;
        instructor = name;
        students = st;
    }

    /**
     * This is the getter method for the course id.
     */
    public String getCourseId() {
        return courseId;
    }

    /**
     * This is the getter method for the instructor name.
     */
    public String getInstructor() {
        return instructor;
    }

    /**
     * This is the getter method for the course section id.
     */
    public String getSectionId() {
        return sectionId;
    }

    /**
     * This is the getter method for the array of Student
     * objects.
     */
    public Student[] getStudents() {
        return students;
    }

    /**
     * This is the getter method for the course term.
     */
    public String getTerm() {
        return term;
    }

    /**
     * This is the getter method for the course year.
     */
    public String getYear() {
        return year;
    }

    /**
     * This is the setter method for the course id.
     *
     * @param cid the course id
     */
    public void setCourseId(String cid) {
        courseId = cid;
    }

    /**
     * This is the setter method for the instructor name.
     *
     * @param i the course instructor's name
     */
    public void setInstructor(String i) {
        instructor = i;
    }

    /**
     * This is the setter method for the course section id.
     *
     * @param String the course section id
     */
    public void setSectionId(String sid) {
        sectionId = sid;
    }

    /**
     * This is the setter method for the array of Students
     *
     * @param s[] the array of Students
     */
    public void setStudents(Student[] s) {
        students = s;
    }

    /**
     * This is the setter method for the course term.
     *
     * @param t the term the course is offered
     */
    public void setTerm(String t) {
        term = t;
    }

    /**
     * This is the setter method for the course year.
     *
     * @param y the year the course is offered
     */
    public void setYear(String y) {
        year = y;
    }
}