package net.server.sendmail;

import javax.servlet.http.HttpServletRequest;

public class WebSearch {

    boolean m_bSuccess = false;			// Indicates that properties have been properly initialized
    static String m_sError = null;		// Flags an error condition to the client
    String m_sSearchString = null;		// The message to be emailed
    String m_sRecipientEmail = null;	// The recipient's email address


    /**************************************************************
     *	No-arg constructor
     **************************************************************/
    public WebSearch() {
        System.out.println("\n*** Starting WebSearch");
    }//end constructor


    /**************************************************************
     *	Method processRequest
     *	Gets input parameters from the jsp and then acts as the
     *	main method
     **************************************************************/
    public void processRequest(HttpServletRequest request) {
        m_sSearchString = request.getParameter("txtSearch");
        m_sRecipientEmail = request.getParameter("txtEmail");

        m_sError = null;
        m_bSuccess = false;

        //-- Check for blank fields before setting email properties
        if ((this.m_sSearchString == null) |
                (this.m_sRecipientEmail == null)) {
            m_bSuccess = false;
        } else if ((m_sSearchString.equals("")) |
                (m_sRecipientEmail.equals(""))) {

            m_bSuccess = false;
        } else {

            m_bSuccess = true;
//-- Create a new instance of the SearchThread class, initialize properties
            new SearchThread(m_sSearchString,
                    m_sRecipientEmail);
        }
    }// end method


    /**************************************************************
     *	Method getError
     *	@return String representing an error message
     *	Accessor method used by the JSP for handling
     **************************************************************/
    public String getError() {
        return m_sError;
    }


    /**************************************************************
     *	Method getSearchString
     *	@return String representing representing the search criteria
     *	Accessor method used by the JSP to display the search string
     **************************************************************/
    public String getSearchString() {
        return m_sSearchString;
    }


    /**************************************************************
     *	Method success
     *	@return boolean indicating whether the properties have
     *	been set correctly in order to proceed with the search
     **************************************************************/
    public boolean success() {
        return m_bSuccess;
    }


}// end class


