package net.server.sendmail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class SearchThread extends Thread {

    String m_sSenderEmail = "lyon@docjava.com";

    String m_sServerHostName = "www.docjava.com";
    String m_sRecipientEmail = null;
    String m_sSearchString = null;

    Thread searchThread;


    /**************************************************************
     *	SearchThread Constructor
     *	@param search - the string containing the search criteria
     *	@param email - the recipient email address
     *	Sets the search string and email address properties and
     *	starts a new thread
     **************************************************************/
    SearchThread(String search, String email) {
        System.out.println("\nCreated new SearchThred;");
        this.m_sSearchString = search;
        this.m_sRecipientEmail = email;

        //-- Create and start the thread
        searchThread = new Thread(this);
        searchThread.start();
    }


    /**************************************************************
     *	Overidden run() method
     *	This contains the code we want to run inside the new thread
     **************************************************************/
    public void run() {
        System.out.println("SearchThread started.");
        String msg = searchAllTheWeb(m_sSearchString);
        msg = msg +
                "<x-html><!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><html>"
                + "<head><title>DocJavaSearch results!</title></head>";

        email(msg);
    }


    /**************************************************************
     *	Method getSearch
     *	@param s - the string containing the search criteria
     *	@return String - the String containing the search results
     *	Queries each search engine, passing in the query string
     *	Acccessor method used only to return the search results
     *	Not used in normal search process
     **************************************************************/
    public String getSearch(String s) {
        return searchAllTheWeb(s);
    }// end method


    /**************************************************************
     *	Method searchAllTheWeb
     *	@param search - the string containing the search criteria
     *	@return String - the String containing the search results
     *	Queries each search engine, passing in the query string
     **************************************************************/
    public String searchAllTheWeb(String search) {

        //-- alltheweb.com
        String s0 = ("http://www.alltheweb.com"
                + "/cgi-bin/search?exec=FAST+Search&type=all&"
                + "query=" + search);

        //-- go.com
        String s1 = ("http://www.go.com/Split?pat=go&col=WW&qt="
                + search);

        //-- google.com
        String s2 = ("http://google.com/search?q="
                + search);

        //-- northernlight.com
        String s3 = ("http://www.northernlight.com/"
                + "nlquery.fcg?cb=0&qr="
                + search + "&search.x=28&search.y=8");

        //-- webcrawler.com
        String s4 = ("http://www.webcrawler.com/"
                + "cgi-bin/WebQuery?searchText=" + search);

        return getUrlResult(s0) +
                getUrlResult(s1) +
                getUrlResult(s2) +
                getUrlResult(s3) +
                getUrlResult(s4);

    }// end method


    /**************************************************************
     *	Prints out the message to command line
     **************************************************************/
    public void print(String s) {
        System.out.println(s);

    }// end method


    /**************************************************************
     *	Invokes the email applet and sends required info to
     *	send the email
     **************************************************************/
    public void email(String msg) {
        //System.out.println ("\n*** Sending email info to email applet.");

        //System.out.println ("ServerHostName = " + m_sServerHostName);
        //System.out.println ("Recipient Email = " + m_sRecipientEmail);
        //System.out.println ("Sender Email = " + m_sSenderEmail);
        //System.out.println ("Message = " + m_sMessage);

        net.server.sendmail.SendMailApplet mail = new net.server.sendmail.SendMailApplet();

        mail.setSenderEmail(m_sSenderEmail);
        mail.setRecipientEmail(m_sRecipientEmail);
        mail.setMailServerHostName(m_sServerHostName);
        mail.setMessage(msg);

        try {
            mail.send();
        } catch (IOException e) {
            System.err.println(
                    "Error sending email:\n"
                    + e.getMessage());
        }

    }// end method



    /**************************************************************
     *	Method getUrlResult
     *	Queries a website with the url provided and returns the results
     *	@param search - the string representing the search query
     *	for a particular search engine
     **************************************************************/
    // sendmail.SearchThread.getUrlResult(searchString);
    public static String getUrlResult(String search) {
        System.out.println("*** Getting search results...");

        try {
            URL url = new URL(search);
            String nextLine;
            Vector v = new Vector();

            BufferedReader br = new BufferedReader(
                    new InputStreamReader(
                            url.openStream()));
            while ((nextLine = br.readLine()) != null)
                v.addElement(nextLine);

            String s[] = new String[v.size()];

            for (int i = 0; i < s.length; i++)
                s[i] = (String) v.elementAt(i);


            String w = "";
            for (int i = 0; i < s.length; i++)
                w = w + s[i] + "\n";

            return w;

        } catch (MalformedURLException e) {
            System.out.println(e.getMessage());

        } catch (IOException e) {
            System.out.println(e.getMessage());
        }

        return null;

    }// end method


}// end class doWebSearch
