/**
 * Class LexStructure - root class for rmi.rmiSynth.lex.Lex classes
 * Each structure(class, method, field) has name, modifier, and type(except class)
 * @author Roman Yedokov
 */

package net.rmi.rmiSynth.lex;


abstract public class LexStructure {
    private String name;		//Name
    private LexModif modif;		//Modifier
    private LexType type;		//Type

    /**
     * Constructor
     */
    public LexStructure() {
        name = "";
        modif = new LexModif();
        type = new LexType();
    }

    /**
     * Gets name of structure
     */
    public String getName() {
        return name;
    }

    /**
     * Sets name of structure
     *
     * @param _name New name
     */
    public void setName(String _name) {
        name = _name;
    }

    /**
     * Gets modifier of structure
     */
    public LexModif getModif() {
        return modif;
    }

    /**
     * Sets modifier of structure
     *
     * @param _modif New modifier
     */
    public void setModif(LexModif _modif) {
        modif = _modif;
    }

    /**
     * Gets type of structure
     */
    public LexType getType() {
        return type;
    }

    /**
     * Sets type of structure
     *
     * @param _type New type
     */
    public void setType(LexType _type) {
        type = _type;
    }

    /**
     * Header to string
     *
     * @return s modifier + type + name
     */
    public String getHeader() {
        String s = "";
        s = s + getModif().toString();
        s = s + getType().toString();
        s = s + getName();
        return s;
    }
}
