package net.rmi.rjs.jobs;

// net.rmi.rjs.jobs.FractalsOld
import gui.ClosableJFrame;
import gui.In;
import j2d.Images;
import j2d.ShortImageBean;

import javax.swing.*;
import java.awt.*;
import java.io.Serializable;
import java.rmi.RemoteException;

public class FractalsOld {
    private final FractalLogicOld fractalLogicOld = new FractalLogicOld();

    public FractalsOld() {
    }
    private  ComputeJobs getComputeJobs(Dimension d) {
        ComputeJobs cjs = new ComputeJobs();
        cjs.add(getComputeJob(d.width, d.height));
        cjs.add(getComputeJob(d.width, d.height));
        return cjs;
    }

    public static void main(String args[]) {
        //testMandelbrot();
        FractalsOld f = new FractalsOld();
        f.testComputeJobs();
    }


    public void testComputeJobs() {
        final Dimension jobDimension = new Dimension(200, 400);

        fractalLogicOld.getAns().add(getComputeJobs(jobDimension));
        ClosableJFrame cjf = new ClosableJFrame();
        Container c = cjf.getContentPane();
        c.setLayout(new GridLayout(1,0));
        c.add(new MultiThreadedPanel(jobDimension));
        cjf.setSize(new Dimension(400, 400));
        cjf.setVisible(true);
    }

    public  ComputeJob getComputeJob(final int w, final int h) {
        return new ComputeJob() {
            public Serializable getAnswer() {
                ShortImageBean sib = new ShortImageBean(w, h);
                fractalLogicOld.mandelbrot(sib.getR(), sib.getG(), sib.getB());
                return sib;
            }
        };
    }

    public void testComputeJob() {
        ClosableJFrame cjf = new ClosableJFrame("mandlebrot") {
            public void paint(Graphics g) {
                try {
                    Dimension d = getSize();
                    ComputeJob cj = getComputeJob(
                            d.width, d.height);
                    Serializable s = cj.getAnswer();
                    if (s instanceof ShortImageBean) {
                        ShortImageBean sib = (ShortImageBean) s;
                        g.drawImage(sib.getImage(), 0, 0, this);
                    }
                } catch (RemoteException e) {
                    In.message(e);

                }
            }

        };
        cjf.setSize(400, 400);
        cjf.setVisible(true);
    }


    public FractalLogicOld getFractalLogic() {
        return fractalLogicOld;
    }

    private class MultiThreadedPanel extends JPanel {
        private final Dimension jobDimension;


        Images imgs = new Images();
        Answers ans = fractalLogicOld.getAns();
        Serializable sa[] = ans.getAnswers();

        public MultiThreadedPanel(Dimension jobDimension) {
            this.jobDimension = jobDimension;
            
        }

        public void paint(Graphics g) {


            System.out.println("got:"+sa.length+" answers.");
            for (int i = 0; i < sa.length; i++) {

                Serializable s = sa[i];
                if (s instanceof ShortImageBean) {
                    ShortImageBean sib = (ShortImageBean) s;
                    imgs.add(sib.getImage());
                    g.drawImage(imgs.getImage(jobDimension, 2,1), 0, 0, this);
                }
            }

        }
    }
}