/*
 * Created on Jun 20, 2005
 */
package net.rmi.rjs.fc;

import java.awt.Dimension;

import j2d.ShortImageBean;
import j2d.ImageUtils;
import net.rmi.rjs.jobs.FractalShortImageBean;
import net.rmi.rjs.jobs.FractalLogic;
import java.io.*;
import java.awt.*;

/**
 * @author Francisco Castellanos
 *
 */
public class FractalsJob_1 {

	public static void main(String[] args) {
		
		Dimension d = new Dimension(400, 800);
		int px = 0;
		int py = 0;
		int fromPx = 0;
		int toPx = 400;
		int fromPy = 0 ;
		int toPy = 100;
		File f = null;
		
		ShortImageBean sib = new ShortImageBean(d.width, d.height);
		FractalShortImageBean s = new FractalShortImageBean(px, py,fromPx, toPx, fromPy, toPy);
		FractalLogic fl = new FractalLogic();
		
		s.setR(sib.getR());
		s.setG(sib.getG());
		s.setB(sib.getB());
		System.out.println("Processing piece Image fp=" + fromPy + " tp=" + toPy);
		for (int y = fromPy; y < toPy; y++){
			for (int x = fromPx; x < toPx; x++) {
		          fl.mandelbrot(x, y, s.getR(), s.getG(), s.getB());          
		    }
        }
		
		//ImageUtils.saveAsPPMgz(s.getProcessedImage(), args[0]+ "Fractals_out1.ppm.gz");
		if (args.length > 0) 
			f = new File(args[0] + "Fractals_out1.ppm.jar");
		else
		    f = new File("Fractals_out1.ppm.jar");
		try{
		f.createNewFile();
		}catch(Exception e){
			e.printStackTrace();
		}
		
		Image i = s.getProcessedImage();
		System.out.println("Height= " + i.getHeight(null));
		System.out.println("Width= " + i.getWidth(null));		
		ImageUtils.saveAsPPMJar(i, f);
	}
}
