package net.rmi.pawelGrid.RmiFileTrans;

import futils.Futil;
import gui.In;
import net.rmi.pawelGrid.LusCs.LusRcvr;
import net.rmi.pawelGrid.LusCs.RemoteJob;

import java.io.File;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

/**
 * Created by IntelliJ IDEA. User: pkrepszt Date: Mar 13, 2005 Time:
 * 7:28:49 PM To change this template use File | Settings | File
 * Templates.
 */
public class FileTransClient {
    private FileTransInterface fti = null;


    public FileTransInterface getFti() {
        return fti;
    }

    private FileTransInterface lookupServer(String rmiUrl)
            throws NotBoundException,
                   java.net.MalformedURLException,
                   RemoteException {
        System.out.println("Naming.lookup(rmiUrl) " + rmiUrl);
        FileTransInterface rh = (FileTransInterface)
                Naming.lookup(rmiUrl);
        return rh;
    }

    public void putJobJar(String rmiUrl, File f) {
        System.out.println("Location to send file " + rmiUrl);
        try {
            fti = lookupServer(rmiUrl);
            byte b[] = Futil.readBytes(f);
            System.out.println("got b.length=" + b.length);
            RemoteJob rj = new RemoteJob();
            rj.setJarFileName(f.getName());
            rj.setJarContents(b);
            rj.setReturnIpAddress(LusRcvr.getLusIp());
            fti.putJob(rj);

        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (IOException e) {
            In.message(e);

        }
    }

    //todo you must return an answer to the lus using
    // your putFile so that the lus can return the answer
    // to the web server.
    // todo: Action Item.
    public void getJarAnwser(String rmiUrl, File f, String ipAddress) {

        System.out.println("Location to send file " + rmiUrl);
        try {
            fti = lookupServer(rmiUrl);
            byte b[] = Futil.readBytes(f);
            System.out.println("got b.length=" + b.length);
            //fti.putAnsFile("Anwser.jar", b);
            fti.putFile(f.getName(), b);
        } catch (NotBoundException e) {
            e.printStackTrace();
        } catch (java.net.MalformedURLException e) {
            e.printStackTrace();
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

