package net.rmi.pawelGrid.RmiFileTrans;


import futils.Futil;
import net.rmi.pawelGrid.LusCs.CSAnswerFactory;
import net.rmi.pawelGrid.LusCs.RemoteJob;
import utils.SystemUtils;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

/**
 * Created by IntelliJ IDEA. User: pkrepszt Date: Mar 13, 2005 Time:
 * 7:25:37 PM To change this template use File | Settings | File
 * Templates.
 */
public class FileServerImplemention
        extends UnicastRemoteObject
        implements FileTransInterface {

    public static String REMOTE_NAME = "RmiFileServerMain";
    private String ipAddressOfPutFiles;
    public FileServerImplemention()
            throws RemoteException {
    }
    /**
     * This is implements in the computer server in order
     * to obtain a job, executed and return the answer to the LUS
     * via the putFile.
     * @param rj
     * @throws RemoteException
     */
    public void putJob(RemoteJob rj) throws RemoteException {
        File f = new File(SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                rj.getJarFileName());
        Futil.writeBytes(f, rj.getJarContents());
        new CSAnswerFactory(f, rj.getReturnIpAddress());
    }
    /**
     * Call this method to put data into the file system of
     * a remote server.
     * Use this to put an answer into the LUS from the CS.
     *
     * @param fileName
     * @param data
     * @throws RemoteException
     */
    public void putFile(String fileName, byte data[])
            throws RemoteException {
        if (data == null) System.out.println("Data=null!");
        File f = new File(
                SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                fileName);
        Futil.writeBytes(f, data);
        System.out.println("wrote file:" + f.getAbsolutePath());

    }
//TODO update CS state to IDLE
    public File getFile(String fileName, String ip) throws RemoteException {
        File f = new File(
                SystemUtils.getUserHome() +
                SystemUtils.getDirectorySeparator() +
                fileName);
       // Lus.updateInfoFrame(ip);
        //new LusAnwserFactory(f);
        return f;
    }
}

