package net.rmi.pawelGrid.RmiFileTrans;


import gui.In;
import net.rmi.utils.RmiRegistryUtils;

import java.rmi.RemoteException;
import java.rmi.registry.Registry;

/**
 * Created by IntelliJ IDEA. User: pkrepszt Date: Mar 13, 2005 Time:
 * 7:30:21 PM To change this template use File | Settings | File
 * Templates.
 */
public final class FileServer {
    private static FileServer fs = null;

    public static void startFileServer() {
        if (fs == null)
          fs = new FileServer();

    }

    private FileServer() {

        try {
            startServer();
        } catch (RemoteException e) {
            In.message(e);
        }
    }


    private void startServer()
            throws RemoteException {
        println("starting server");
        bindInstances(new FileServerImplemention());
    }


    private void bindInstances(FileServerImplemention fsi) {
        println("binding remote instances");
        Registry r = RmiRegistryUtils.getRegistry();
      

        System.out.println("FileTransInterface:"+fsi);
        try {
            r.rebind(FileServerImplemention.REMOTE_NAME, fsi);
        } catch (RemoteException e) {
            In.message(e);

        }
        println("waiting for invocations");

    }

    public static void println(Object o) {
        System.out.println(o);
    }
}
