/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package net.rmi.pawelGrid.LusCs;

import futils.Futil;
import gui.In;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 29, 2005
 * <p/>
 * Time: 4:58:50 PM
 */
public class RemoteJob implements Serializable{
    private String returnIpAddress;
    private String jarFileName;
    private byte jarContents[];

    public String getReturnIpAddress() {
        return returnIpAddress;
    }

    public void setReturnIpAddress(String returnIpAddress) {
        this.returnIpAddress = returnIpAddress;
    }

    public String getJarFileName() {
        return jarFileName;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public byte[] getJarContents() {
        return jarContents;
    }

    public void setJarContents(byte[] jarContents) {
        this.jarContents = jarContents;
    }
    public String toString(){
        return "return address:"+returnIpAddress+"\n" +
                "JarFileName:"+jarFileName+"\n " +
                        "Number of Bytes:"+jarContents.length;
    }
    public static void main(String[] args) {
        RemoteJob rj = new RemoteJob();
        File f = Futil.getReadFile("select a jar file");
        rj.setJarFileName(f.getName());
        rj.setJarContents(Futil.readBytes(f));
        try {
            rj.setReturnIpAddress(LusRcvr.getLusIp());
        } catch (IOException e) {
            In.message(e);

        }
        System.out.println(rj);
    }
}
