package net.rmi.pawelGrid.LusCs;


/**

 * Created by IntelliJ IDEA.

 * User: pkrepszt

 * Date: Feb 16, 2005

 * Time: 3:52:17 PM

 * To change this template use File | Settings | File Templates.

 */

//package net.multicast;

import futils.Futil;
import gui.JInfoFrame;
import gui.run.RunButton;
import net.multicast.McastUtil;
import net.rmi.pawelGrid.RmiFileTrans.FileServer;
import net.rmi.pawelGrid.RmiFileTrans.FileServerImplemention;
import net.rmi.pawelGrid.RmiFileTrans.FileTransClient;

import java.awt.*;
import java.io.File;


public class Lus {
    private int mcastPort = 7234;
    private McastUtil mcx = new McastUtil(mcastPort);
    private JInfoFrame jif = new JInfoFrame("LAN LUS");
    private FileTransClient ftc = new FileTransClient();
    public CsRecords csRecords = new CsRecords();


    public static void main(String[] args) {
        // new FileServer();
        new Lus();
        System.out.println("start file server!");
        FileServer.startFileServer();
        System.out.println("file server started!");
    }

    public Lus() {
        mcx.enableLoopBack();
        processWithMulticastSocket();
    }



    public void processWithMulticastSocket() {

        // ChatRcvr will handle the incoming
        // Data and print it out to STDN output.
        new LusRcvr(mcx, jif, csRecords);
        Container c = jif.getContentPane();

        c.add(
                new RunButton("Get Jar File") {
                    public void run() {
                        getJar();
                    }
                }, BorderLayout.SOUTH);

        jif.setSize(700, 300);
        jif.setVisible(true);
    }
// replace with real job factory leater

    public void getJar() {
        Thread t = new Thread(
                new Runnable() {
                    public void run() {
                        File jar = Futil.getReadFile("select a jar file");
                        if (jar == null)
                            return;

                        String rmiUrl = getBestRmiUrl();
                        if (rmiUrl == null)
                            return;
                        System.out.println(" Best Ip is " + rmiUrl);
                        // now send this jar to CS RMI?
                        ftc.putJobJar(rmiUrl, jar);

                    }
                });
        t.start();
    }

    // get the CS ip that the job will be send
    /**
     * String location = "rmi://" +serverHostName +"/" +REMOTE_NAME;
     */
    public String getBestRmiUrl() {
        CsRecord cs = csRecords.getLeastLoaded();
        if (cs == null)
            return null;

        String s = "rmi://" +
                cs.getIpAddress().getHostAddress() +
                "/" +
                FileServerImplemention.REMOTE_NAME;
        System.out.println("rmiUrl=" + s);
        return s;
    }



}





