package net.multicast.multiMedia;

import net.multicast.McastUtil;
import sound.Utils;

import javax.sound.sampled.*;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Dec 6, 2004
 * Time: 2:37:32 PM
 */
public class StreamingXmitterAudioMulticastThread
        extends Thread implements Runnable {
    SourceDataLine line;
    String errStr = null;
    AudioInputStream ais = null;
    private final int bufSize = 16384;
    public static final int PORT = 4321;
    private McastUtil mcu = new McastUtil(PORT);

    private void sendADataGram(byte[] data,
                               int numberOfBytesRead) {
        try {
            byte b[] = new byte[numberOfBytesRead];
            System.out.println("number of bytes sent=" + numberOfBytesRead);
            for (int i = 0; i < b.length; i++)
                b[i] = data[i];
            mcu.sendBytes(b);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    StreamingXmitterAudioMulticastThread(AudioInputStream ais) {
        this.ais = ais;
        mcu.disableLoopBack();
    }



    public void run() {
        AudioFormat format = Utils.get8khzMono8Format();
        AudioInputStream audioInputStream =
                AudioSystem.getAudioInputStream(format, ais);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        try {
            line = (SourceDataLine) AudioSystem.getLine(info);
            line.open(format, bufSize);
        } catch (LineUnavailableException ex) {
            ex.printStackTrace();
        }
        int numBytesRead = 0;

        // start the source data line
        line.start();
        while (true) {
            byte[] data = new byte[16534];
            try {
                while ((numBytesRead = audioInputStream.read(data))
                        == -1)
                    Thread.sleep(1);
                sendADataGram(data, numBytesRead);
                //threadedAudioPlayer();
                //playAudio(numBytesRemaining, data);
            } catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        cleanUp();
    }

    public void threadedAudioPlayer() {
        Thread t = new Thread(new Runnable() {
            public void run() {
                try {
                    while (true) {
                        byte b[] = mcu.getBytes();
                        System.out.println("rcving bytes!!=" + b.length);
                        playAudio(b.length, b);
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }

    private void playAudio(int numBytesRemaining, byte[] data) {
        while (numBytesRemaining > 0)
            numBytesRemaining -= line.write(data, 0, numBytesRemaining);
    }

    private void cleanUp() {
        line.drain();
        line.stop();
        line.close();
        line = null;
    }
}
