package net.multicast.multiMedia;

import gui.In;
import sound.Utils;
import sound.soundDemo.JavaSound;

import javax.sound.sampled.*;
import java.io.IOException;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Nov 29, 2004
 * Time: 3:20:19 PM
 */
public class MainAudioMcastXmitter implements Runnable {
    TargetDataLine targetDataLine;
    Thread thread;
    String errStr = "";


    public MainAudioMcastXmitter() {
    }

    public static void main(String[] args) {
        MainAudioMcastXmitter sa = new MainAudioMcastXmitter();
        sa.start();
    }

    public void start() {
        errStr = null;
        thread = new Thread(this);
        thread.setName("Capture");
        thread.start();
    }

    public void stop() {
        thread = null;
    }

    public void run() {
        initAudioStuff();
        targetDataLine.start();
        processAudioData();

        // we reached the end of the stream.  stop and close the line.
        targetDataLine.stop();
        targetDataLine.close();
        targetDataLine = null;
    }

    private void processAudioData() {
        AudioInputStream ais = new AudioInputStream(targetDataLine);
        StreamingXmitterAudioMulticastThread sp =
                new StreamingXmitterAudioMulticastThread(ais);
        sp.start();
        while (thread != null)
            sleep();
        try {
            ais.reset();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sleep() {
        try {
            Thread.sleep(1);
        } catch (InterruptedException e) {

        }
    }

    private AudioFormat initAudioStuff() {
        // define the required attributes for our line,
        // and make sure a compatible line is supported.

        AudioFormat format = Utils.get8khzMono8Format();
        DataLine.Info info = new DataLine.Info(TargetDataLine.class,
                format);
        if (!AudioSystem.isLineSupported(info)) {
            shutDown("Line matching " + info + " not supported.");
        }
        getAndInitTDL(info, format);
        return format;
    }

    private void getAndInitTDL(DataLine.Info info, AudioFormat format) {
        // get and open the target data line for capture.

        try {
            initTargetDataLine(info, format);
        } catch (LineUnavailableException ex) {
            shutDown("Unable to open the line: " + ex);
        } catch (SecurityException ex) {
            JavaSound.showInfoDialog();
        } catch (Exception ex) {
        }
    }

    public void initTargetDataLine(DataLine.Info info, AudioFormat format)
            throws LineUnavailableException {
        targetDataLine = (TargetDataLine) AudioSystem.getLine(info);
        targetDataLine.open(format, targetDataLine.getBufferSize());
    }

    private void shutDown(String s) {
        In.message("shutting down:"+s);
        System.exit(0);
    }
}

