package net.multicast.chat;

import gui.JInfoFrame;
import net.multicast.McastUtil;

import java.io.IOException;
import java.net.InetAddress;

/**
 * Copyright DocJava, inc.
 * User: lyon
 * Date: Oct 27, 2004
 * Time: 5:08:08 AM
 */
public class ChatRcvr extends Thread {
    private McastUtil mcu;
    private JInfoFrame jif;

    public ChatRcvr(McastUtil mcu, JInfoFrame jif) {
        this.jif = jif;
        this.mcu = mcu;
        start();                // start calls run
    }

    public void run() {
        try {
            while (true) {
                processBytes();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processBytes() throws IOException {
        String tmp;
        byte b[] = mcu.getBytes();
        tmp = new String(b, 0, b.length);
        InetAddress address = mcu.getInetAddress();
        jif.println("getHostName="+address.getLocalHost());
        jif.println("\n\nRecived: \"" +
                "ip=" + address +
                tmp +
                "\"\nMessage Length is: " +
                tmp.length());
    }
}
