package math.fourierTransforms;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 13, 2005
 * <p/>
 * Time: 6:32:16 AM
 */
public class IntegerFFT {
    /*
    SUBROUTINE COMP(IS,IC)
C
C SUBROUTINE TO COMPENSATE SIN AND COS FOR MODULUS
C ERRORS
C
IT=MPY(IS,IS)/2+MPY(IC,IC)/2
IS=(IS-MPY(IS,IT))+IS/2
IC=(IC-MPY(IC,IT))+IC/2
RETURN
END
    */
    static int is = 0;
    static int ic = 0;
    /**
     * This subroutine alters the field variables,
     * is and ic.
     */
    public static void comp(){
        int it = mpy(is,is)/2 + mpy(ic,ic)/2;
        is = (is - mpy(is,it)) + is/2;
        ic = (ic - mpy(ic,it)) + ic/2;
    }
    public static void testBitr() {
        int i = 0x7F;
        int j = bitvr(i,8);
        int k = bitr(i,8);
        System.out.println("i=" + Integer.toString(i, 2));
        System.out.println("j="+Integer.toString(j,2));
        System.out.println("k=" + Integer.toString(k, 2));
    }
    // the following is a working bit reversal subroutine
    public static int bitr(int j,int numBits) {
        int ans = 0;
        for (int i = 0; i < numBits; i++) {
            ans = (ans << 1) + (j & 1);
            j = j >> 1;
        }
        return ans;
    }
    // the following is a translation of the fortran
    // subroutine, this was a pain tp translate.
    /**
     * C SUBROUTINE WHICH RETURNS NBITS BITS OF j REVERSED .
     */
    public static int bitvr(int j,  int NBITS) {
        int ans = 0;
        for (int k=0; k < NBITS; k++){
            //ans = (ans + ans) + ((j / 2 )* 2);
            ans = (ans + ans) + (j&1);
            j = j / 2;
        }
       return ans;
    }

    public static int mpy(int i__, int j) {
        /* Initialized data */

        int imad = 64;
        int imid = 128;

        /* System generated locals */
        int ret_val = 0;


        /* Local variables */
        int ii = 0;
        int it = 0;
        int ilef = 0;
        int jlef = 0;
        int irid = 0;
        int irit = 0;
        int jrit = 0;

        ilef = i__ / imid;
        irit = i__ - ilef * imid;
        jlef = j / imid;
        jrit = j - jlef * imid;
        ii = irit * jrit / imid + irid * jlef + jrit * ilef;
        ret_val = (it + i_sign(imad, ii)) / imid + ilef * jlef;
        return ret_val;
    } /* mpy_ */

    public static int i_sign(int value, int sign) {
        return sign * Math.abs(value);
    }
}
