package j3d.utils.propertyEditors;

import javax.swing.*;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;


public class PEComboBoxBuilder extends PropertyEditorBuilder {

    private JComboBox comboBox;

    public PEComboBoxBuilder(String[] choices, Object obj, String name) {
        comboBox = new JComboBox(choices);
        init(obj, name);
    }

    public void addEventListener(final Object obj, final Method writer) {
        comboBox.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                writeToObject(obj, writer, new Integer(comboBox.getSelectedIndex()));
            }
        });
    }

    public JComponent getSwingJComponent() {
        return comboBox;
    }

    public void setSwingJComponentFromObject(final Object obj, final Method reader) {
        comboBox.setSelectedIndex(((Integer) readFromObject(obj, reader)).intValue());
    }

}