package j3d.utils.propertyEditors;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;


public class PEButtonBuilder extends PEAbstractButtonBuilder {

    private static Color mutedGreen = new Color(0, 200, 0);
    private static Color mutedRed = new Color(200, 0, 0);

    public PEButtonBuilder(final Object obj, final String name) {
        super(obj,
                name,
                // An on-the-fly declaration of an anomymous subclass of JButton.
                new JButton(name) {
                    public void setSelected(boolean b) {
                        super.setSelected(b);
                        if (b) {
                            setText("Stop " + name);
                            setBackground(mutedRed);
                            setForeground(Color.white);
                        } else {
                            setText("Start " + name);
                            setBackground(mutedGreen);
                            setForeground(Color.black);
                        }
                    }
                });
    }

    public void addEventListener(final Object obj,
                                 final Method writer) {
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                boolean b = button.isSelected();
                writeToObject(obj, writer, new Boolean(b));
                button.setSelected(b);
            }
        });
    }

    public void setSwingJComponentFromObject(final Object obj, final Method reader) {
        button.setSelected(((Boolean) readFromObject(obj, reader)).booleanValue());
    }

}