package j3d.utils;

/*
      %Z%%M% %I% %E% %U%

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;

import javax.media.j3d.*;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class RotAxis extends Switch implements Java3DExplorerConstants {


    // axis to align with
    Vector3f rotAxis = new Vector3f(1.0f, 0.0f, 0.0f);
    // offset to ref point
    Vector3f refPt = new Vector3f(0.0f, 0.0f, 0.0f);

    TransformGroup axisTG; // the transform group used to align the axis

    // Temporaries that are reused
    Transform3D tmpTrans = new Transform3D();
    Vector3f tmpVector = new Vector3f();
    AxisAngle4f tmpAxisAngle = new AxisAngle4f();

    // geometric constants
    Point3f origin = new Point3f();
    Vector3f yAxis = new Vector3f(0.0f, 1.0f, 0.0f);

    public RotAxis(float axisLength) {
        super(Switch.CHILD_NONE);
        setCapability(Switch.ALLOW_SWITCH_READ);
        setCapability(Switch.ALLOW_SWITCH_WRITE);

        // set up the proportions for the arrow
        float axisRadius = axisLength / 120.0f;
        float arrowRadius = axisLength / 50.0f;
        float arrowHeight = axisLength / 30.0f;


        // create the TransformGroup which will be used to orient the axis
        axisTG = new TransformGroup();
        axisTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        axisTG.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        addChild(axisTG);

        // Set up an appearance to make the Axis have
        // blue ambient, black emmissive, blue diffuse and white specular
        // coloring.
        Material material = new Material(blue, black, blue, white, 64);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);

        // create a cylinder for the central line of the axis
        Cylinder cylinder = new Cylinder(axisRadius, axisLength, appearance);
        // cylinder goes from -length/2 to length/2 in y
        axisTG.addChild(cylinder);

        // create a SharedGroup for the arrowHead
        Cone arrowHead = new Cone(arrowRadius, arrowHeight, appearance);
        SharedGroup arrowHeadSG = new SharedGroup();
        arrowHeadSG.addChild(arrowHead);

        // Create a TransformGroup to move the cone to the top of the
        // cylinder
        tmpVector.set(0.0f, axisLength / 2 + arrowHeight / 2, 0.0f);
        tmpTrans.set(tmpVector);
        TransformGroup topTG = new TransformGroup();
        topTG.setTransform(tmpTrans);
        topTG.addChild(new Link(arrowHeadSG));
        axisTG.addChild(topTG);

        // create the bottom of the arrow
        // Create a TransformGroup to move the cone to the bottom of the
        // axis so that its pushes into the bottom of the cylinder
        tmpVector.set(0.0f, -(axisLength / 2), 0.0f);
        tmpTrans.set(tmpVector);
        TransformGroup bottomTG = new TransformGroup();
        bottomTG.setTransform(tmpTrans);
        bottomTG.addChild(new Link(arrowHeadSG));
        axisTG.addChild(bottomTG);

        updateAxisTransform();
    }

    public void setRotationAxis(Vector3f setRotAxis) {
        rotAxis.set(setRotAxis);
        float magSquared = rotAxis.lengthSquared();
        if (magSquared > 0.0001) {
            rotAxis.scale((float) (1.0 / Math.sqrt(magSquared)));
        } else {
            rotAxis.set(1.0f, 0.0f, 0.0f);
        }
        updateAxisTransform();
    }

    public void setRefPt(Vector3f setRefPt) {
        refPt.set(setRefPt);
        updateAxisTransform();
    }

    // set the transform on the axis so that it aligns with the rotation
    // axis and goes through the reference point
    private void updateAxisTransform() {
        // We need to rotate the axis, which is defined along the y-axis,
        // to the direction indicated by the rotAxis.
        // We can do this using a neat trick.  To transform a vector to align
        // with another vector (assuming both vectors have unit length), take
        // the cross product the the vectors.  The direction of the cross
        // product is the axis, and the length of the cross product is the
        // the sine of the angle, so the inverse sine of the length gives
        // us the angle
        tmpVector.cross(yAxis, rotAxis);
        float angle = (float) Math.asin(tmpVector.length());

        tmpAxisAngle.set(tmpVector, angle);
        tmpTrans.set(tmpAxisAngle);
        tmpTrans.setTranslation(refPt);
        axisTG.setTransform(tmpTrans);
    }
}
