package j3d.utils;

/*
      @(#)PointAttributesEditor.java 1.2 01/08/01 11:02:21

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.layouts.LeftAlignComponent;
import gui.run.FloatEvent;
import gui.run.FloatListener;
import gui.run.LogFloatLabelJSlider;

import javax.media.j3d.PointAttributes;
import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class PointAttributesEditor extends Box
        implements Java3DExplorerConstants {

    // PointAttributes
    PointAttributes pointAttr;
    float pointSize;
    boolean pointAAEnable;
    String pointAAString = "Point AA";

    public PointAttributesEditor(PointAttributes init) {
        super(BoxLayout.Y_AXIS);
        pointAttr = init;
        pointSize = pointAttr.getPointSize();
        pointAAEnable = pointAttr.getPointAntialiasingEnable();

        LogFloatLabelJSlider pointSizeSlider =
                new LogFloatLabelJSlider("Size", 0.1f, 100.0f, pointSize);
        pointSizeSlider.setMajorTickSpacing(1.0f);
        pointSizeSlider.setPaintTicks(true);
        pointSizeSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                pointSize = e.getValue();
                pointAttr.setPointSize(pointSize);
            }
        });
        add(pointSizeSlider);

        JCheckBox pointAACheckBox = new JCheckBox(antiAliasString);
        pointAACheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                pointAAEnable = checkbox.isSelected();
                pointAttr.setPointAntialiasingEnable(pointAAEnable);
            }
        });

        add(new LeftAlignComponent(pointAACheckBox));
    }
}
