/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;


/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class SpaceStation
        implements Vec3FunctionInterface {
    double sqrt_2 = Math.sqrt(2);

    public SpaceStation() {

    }

    // uu ranges from 0 to 2*PI, but want -PI/4...3*PI/2
    double umin = -Math.PI / 4;
    double umax = 3 * Math.PI / 2;
    double twoPi = 2 * Math.PI;

    public Vec3 getPolarVec3(
            double a,
            double u,
            double b,
            double v) {
        //a ranges from 0 to 1. want it to range from
        //b ranges from 0 to .5.
        //u, v range from 0 to 2PI

        double x, y, z;
        double c = 10/(1+a);
        int n = (int)(b*2*100);
        //double t = Utils.scale(v/twoPi,-1,1);
        double r = c * sin(n*u)*cos(n*v);
        x = r * cos(u) * sin(v);
        y = r * sin(u) * sin(v);
        z = r * cos(v);
        return new Vec3(
                (float) x,
                (float) y,
                (float) z);
    }
    public static void main(String args[]){
        for (int i=0; i < 100; i++){
             System.out.println(legendre(i/100.0, 3)[2]);
        }
    }
    //Use the recurrence relation to evaluate a
    // series of Legendre polynomials at t
    // x must range from -1 to 1;
    public static double[] legendre(double x, int n) {
        double[] p = new double[n];
        p[0] = 1;
        if (n > 1) {
            p[1] = x;
            for (int l = 1; l < (n - 1); l++) {
                p[l + 1] = ((2 * l + 1) * x * p[l] - l * p[l - 1]) /
                        (l + 1);
            }
        }
        return p;
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
