/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;

import ip.transforms.Kernels;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class Gauss implements Vec3FunctionInterface {
    public static final double sqrt_2 = Math.sqrt(2);
    public static final double pi = Math.PI;
    public static final double twoPi = Math.PI * 2;

    public Gauss() {

    }

    public Vec3 getPolarVec3(double r1,
                             double theta1,
                             double r2,
                             double theta2) {


        double x, y, z;

        x = Utils.scale(theta1 / twoPi, -r1, r1);

        y = Utils.scale(theta2 / twoPi, -r1, r1);

        z = Kernels.gauss(x, y, 0, 0, r2);
        double scale = twoPi * r2 * r2;
        z = z * scale;
        return new Vec3((float) x,
                (float) y,
                (float) z);

    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
