/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;



/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class Cornucopia
        implements Vec3FunctionInterface {
    double sqrt_2 = Math.sqrt(2);

    public Cornucopia() {

    }

    // uu ranges from 0 to 2*PI, but want -PI/4...3*PI/2
    double umin = -Math.PI / 4;
    double umax = 3 * Math.PI / 2;
    double twoPi = 2 * Math.PI;

    public Vec3 getPolarVec3(double a,
                             double u,
                             double b,
                             double v) {
        //a ranges from 0 to 1. want it to range from
        //b ranges from 0 to .5.
        //u, v range from 0 to 2PI
        a=a/50;
        b=b/25;
        v = Utils.scale(v/twoPi,-Math.PI,2*Math.PI);
        double x, y, z;
        x = Math.exp(b*v)*cos(v)+Math.exp(a*v)*cos(u)*cos(v);


        y = Math.exp(b * v) * sin(v) + Math.exp(a * v) * cos(u) * sin(v);


        z = Math.exp(a * v) * sin(u);

        return new Vec3((float) x/2,
                (float) y/2,
                (float) z/2);
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
