package j3d.examples.shape.triangles.surfaces.geometries;

import j3d.examples.shape.triangles.surfaces.SurfaceGeometry;
import j3d.examples.shape.triangles.surfaces.SurfaceUniverse;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import java.awt.*;

public class Bowl extends SurfaceGeometry {

    public Bowl(int strips, int stripLength, Color3f c1, Color3f c2) {
        super(strips, stripLength, c1, c2);
    }

    public Vector3d getViewingPosition() {
        return new Vector3d(0, 0.5, 3);
    }

    public double distance(int strip, int index, int segment) {
        double x = x(strip, index, segment);
        double z = z(strip, index, segment);
        return Math.sqrt(x * x + z * z);
    }

    public static void main(String[] args) {
        new SurfaceUniverse("Bowl",
                new Bowl(5, 25,
                        new Color3f(Color.cyan),
                        new Color3f(Color.blue)));
    }

    public double radius(int strip, int segment) {
        // This version makes the outside of the bowl opaque
        return (strip + 1 - segment) / (double) strips;
        // This version makes the inside of the bowl opaque
//    return (strip + segment)/(double)strips;
    }

    public double x(int strip, int index, int segment) {
        return radius(strip, segment) * Math.sin(radians(index));
    }

    public double y(int strip, int index, int segment) {
        double distance = distance(strip, index, segment);
//    System.out.println("strip: " + strip +
//                       "; index: " + index +
//                       "; segment: " + segment +
//                       "; radians: " + radians(index) +
//                       "; radius: " + radius(strip) +
//                       "; x: " + x(strip, index, segment) +
//                       "; y: " + x(strip, index, segment) +
//                       "; z: " + x(strip, index, segment) +
//                       "; distance: " + distance);
        return distance * distance;
    }

    public double z(int strip, int index, int segment) {
        return radius(strip, segment) * Math.cos(radians(index));
    }

}