package j3d.examples.shape.triangles.surfaces;

import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;


public abstract class SurfaceGeometry extends TriangleStripArray {

    /**
     * stripLength is the number of points plotted in each segment of the
     * strip. The number of points stored in each strip is twice
     * stripLength since each strip stores points that zig-zag back and
     * forth between two segments.
     */
    public int stripLength, strips;

    public SurfaceGeometry(int strips, int stripLength, Color3f c1, Color3f c2) {
        super(2 * stripLength * strips,
                TriangleStripArray.COORDINATES |
                TriangleStripArray.COLOR_3,
                indexArray(strips, stripLength));
        this.stripLength = stripLength;
        this.strips = strips;
        for (int strip = 0; strip < strips; strip++) {
            for (int stripIndex = 0;
                 stripIndex < stripLength;
                 stripIndex++) {
                setCoordinate(strip, stripIndex, 0, c1, c2);
                setCoordinate(strip, stripIndex, 1, c1, c2);
            }
        }
    }

    public Vector3d getViewingPosition() {
        return new Vector3d();
    }

    private static int[] indexArray(int strips, int stripLength) {
        int[] indexArray = new int[strips];
        for (int i = 0; i < strips; i++) indexArray[i] = 2 * stripLength;
        return indexArray;
    }

    // Divide by stripLength-1 to include both 0 and 360.
    public double radians(int index) {
        return index * 2 * Math.PI / (stripLength - 1);
    }

    private void setCoordinate(int strip, int stripIndex, int segment,
                               Color3f c1, Color3f c2) {
        double x = x(strip, stripIndex, segment);
        double y = y(strip, stripIndex, segment);
        double z = z(strip, stripIndex, segment);
        Point3d p = new Point3d(x, y, z);
        setCoordinate(strip * 2 * stripLength + 2 * stripIndex + segment, p);
        boolean even = strip % 2 == 0;
        Color3f c = even ?
                (segment == 0 ? c1 : c2) :
                (segment == 0 ? c2 : c1);
        setColor(strip * 2 * stripLength + 2 * stripIndex + segment, c);
    }

    public abstract double x(int strip, int index, int segment);

    public abstract double y(int strip, int index, int segment);

    public abstract double z(int strip, int index, int segment);

}
