/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.examples.ballGrid;

// WrapCheckers3D.java
// Andrew Davison, January 2003, dandrew@ratree.psu.ac.th

/* Illustrates how to create a simple world. The checkboard
   floor is created by CheckerFloor. The background, lighting,
   key controls, and initial user positioning is done here.

   Most of this will stay the same from one example to another.

   floatingSphere() shows how to create a coloured, shiny object
   which is affected by the lighting in the world.

   The scene graph display code is in WrapCheckers3D() and 
   getSceneGraph().
*/


import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import j3d.examples.checkers.CheckerFloor;

import javax.media.j3d.*;
import javax.swing.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import java.awt.*;

// import com.tornadolabs.j3dtree.*;    // for displaying the scene graph

 class BallGridPanel extends JPanel {
     private static final int PWIDTH = 512;   // size of panel
     private static final int PHEIGHT = 512;

      BallGridPanel(){
         setLayout(new BorderLayout());
         setOpaque(false);
         setPreferredSize(new Dimension(PWIDTH, PHEIGHT));
     }

 }
class GridGeometry {
    private static final int BOUNDSIZE = 100;  // larger than world
    protected final static BoundingSphere bounds = new BoundingSphere(
            new Point3d(0, 0, 0), BOUNDSIZE);
    protected int nx;
    protected int ny;
    protected int nz;

    public GridGeometry(int nx, int ny, int nz) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
    }

    public BranchGroup getSceneGraph(float radius) {
        BranchGroup bg = new BranchGroup();

        lightScene(bg);
        addBackground(bg);
        bg.addChild(new CheckerFloor().getBG());

        populateScene(nx, ny, nz, radius, bg);

        bg.compile();
        return bg;
    } // end of getSceneGraph()

    private static void lightScene(BranchGroup bg)
            /* One ambient light, 2 directional lights */ {
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);

        // Set up the ambient light
        AmbientLight ambientLightNode = new AmbientLight(white);
        ambientLightNode.setInfluencingBounds(bounds);
        bg.addChild(ambientLightNode);

        // Set up the directional lights
        Vector3f light1Direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        // left, down, backwards
        Vector3f light2Direction = new Vector3f(1.0f, -1.0f, 1.0f);
        // right, down, forwards

        DirectionalLight light1 =
                new DirectionalLight(white, light1Direction);
        light1.setInfluencingBounds(bounds);
        bg.addChild(light1);

        DirectionalLight light2 =
                new DirectionalLight(white, light2Direction);
        light2.setInfluencingBounds(bounds);
        bg.addChild(light2);
    }  // end of lightScene()

    private static void addBackground(BranchGroup bg) {
        Background back = new Background();
        back.setApplicationBounds(bounds);
        back.setColor(0.17f, 0.65f, 0.92f);    // sky colour
        bg.addChild(back);
    }  // end of addBackground()

    private static void populateScene(
            int i, int j, int k, float r, BranchGroup bg) {
        Appearance blueApp = getAppearance();

        // position the sphere
        Transform3D t3d;
        t3d = new Transform3D();
        TransformGroup tg;//= new TransformGroup();
        //   tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

        //    tg = new TransformGroup(t3d);

        for (int ii = 0; ii < i; ii++) {
            for (int jj = 0; jj < j; jj++) {
                for (int kk = 0; kk < k; kk++) {
                    t3d.set(new Vector3f(ii, jj, kk));
                    // tg.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
                    tg = new TransformGroup(t3d);
                    // tg.setTransform(t3d);
                    tg.addChild(getSphere3D(blueApp, r));   // set its radius and appearance
                    bg.addChild(tg);
                }
            }
        }
    }  // end of populateScene()

    //private Sphere getSphere3D(Appearance blueApp) {
    private static Sphere getSphere3D(Appearance app, float r) {

        Sphere sphere = new Sphere(r, app);
        return sphere;
    }

    private static Appearance getAppearance() {
        Material blueMat = getMaterial();

        // sets ambient, emissive, diffuse, specular, shininess
        blueMat.setLightingEnable(true);

        Appearance blueApp = new Appearance();
        blueApp.setMaterial(blueMat);
        return blueApp;
    }

    private static Material getMaterial() {
        // Create the blue appearance node
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f blue = new Color3f(0.8f, 0.3f, 0.5f);
        Color3f specular = new Color3f(0.9f, 0.9f, 0.9f);

        Material blueMat = new Material(
                blue, black, blue, specular, 25.0f);
        return blueMat;
    }
}
public class BallGridUniverse {


    BallGridPanel panel = new BallGridPanel();

    private static final Point3d USERPOSN = new Point3d(0, 5, 20);
    // initial user position

    private SimpleUniverse su;
    private final GridGeometry gridGeometry;

    public BallGridUniverse(int nx, int ny, int nz) {
        gridGeometry = new GridGeometry(nx,ny,nz);



        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(config);

        panel.add(BorderLayout.CENTER, canvas3D);
        canvas3D.setFocusable(true);
        canvas3D.requestFocus();

        su = new SimpleUniverse(canvas3D);
        initUserPosition();
        // set user's viewpoint
        orbitControls(canvas3D);
        // controls for moving the viewpoint

        su.addBranchGraph(gridGeometry.getSceneGraph(0.05f));

        // j3dTree.updateNodes( su );    // build the tree display window

    } // end of WrapCheckers3D()


    private void orbitControls(Canvas3D c) {
        OrbitBehavior orbit =
                new OrbitBehavior(c, OrbitBehavior.REVERSE_ALL);
        orbit.setSchedulingBounds(GridGeometry.bounds);

        ViewingPlatform vp = su.getViewingPlatform();
        vp.setViewPlatformBehavior(orbit);
    }


    private void initUserPosition() {
        ViewingPlatform vp = su.getViewingPlatform();
        TransformGroup steerTG = vp.getViewPlatformTransform();

        Transform3D t3d = new Transform3D();
        steerTG.getTransform(t3d);

        // args are: viewer posn, where looking, up direction
        t3d.lookAt(USERPOSN, new Point3d(0, 0, 0), new Vector3d(0, 1, 0));
        t3d.invert();

        steerTG.setTransform(t3d);
    }  // end of initUserPosition()


    private Cylinder getCylinder3D(
            float radius, float height, Appearance app) {
        Cylinder cylinder;
        cylinder = new Cylinder(radius, height, app);
        return cylinder;
    }

}