package j2d.io;

import j2d.ImageUtils;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class TestImageIO{
    public static void main(String args[]) {
		System.out.println("Writer formats:");
	    printImageWriterFormats();
		System.out.println("Reader formats:");
		printImageReaderFormats();
    }
    
    public static void printImageWriterFormats() {
        print(ImageIO.getWriterFormatNames());
    }
    public static Image getPNGImage(File f){
        Iterator it = ImageIO.getImageReadersBySuffix("png");
        while (it.hasNext()){
            ImageReader ir = (ImageReader)it.next();
            try {
                BufferedImage bi = ir.read(0);
                return ImageUtils.getImage(bi);
            } catch (IOException e) {
            }
        }
        return null;
    }

 	public static void printImageReaderFormats() {
 		print(ImageIO.getReaderFormatNames());
 	}
 	
 	public static void print(Object o[]) {
        for (int i=0; i < o.length;i++)
            System.out.println(o[i]);
    }
}
