// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.imageproc;

/**
 * This classes allows adjustment of an image using a "Pow
 * Function" for exponential stretching of pixel intensity.
 * Reference: Douglas A. Lyon, "Image Processing in Java"
 */
 public class ExponentialStretchProcessor
        extends ImageProcessor {

    private int lookupTable[] = new int[256];

    /**
     * Create a new ExponentialStretchProcessor
     */
    public ExponentialStretchProcessor(){
        for (int j = 0; j< 256; j++){
            lookupTable[j] = j;
        }
    }

    /**
     * Implementation of ImageProcessor
     */
    public void processImage() throws Exception{
        int pixels[];
        int r, g, b;

        pixels = getPixels();

        for (int i = 0; i<pixels.length; i++){

            // Separate RGB components
            r = (pixels[i] & 0x00FF0000) >> 16;
            g = (pixels[i] & 0x0000FF00) >> 8;
            b = (pixels[i] & 0x000000FF);

            // Adjust the pixel
            r = lookupTable[r];
            g = lookupTable[g];
            b = lookupTable[b];

            // store the processed pixel
            pixels[i] = 0xFF000000 | (r << 16) | (g << 8) | b;
        }

        setPixels(pixels);
    }

    /**
     * Set the exponential coefficient.
     */

    public void setPower(double power){
        double newj;
        for (int j = 0; j<256; j++){
            // new intensity is a stretched version of the original.
            newj = 255.0 * Math.pow((j/255.0), power);
            // saturate if the stretching takes the intensities out of range.
            lookupTable[j] = (int)Math.min(255, newj);
            lookupTable[j] = Math.max(0, lookupTable[j]);
        }
    }
}
