package j2d.gui;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import java.awt.*;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

/**
 * Wrapper class for copying image to system clipboard
 */
public class TransferableImage implements Transferable {
    private Image image;
    private final Toolkit tk = Toolkit.getDefaultToolkit();
    private Clipboard cb = tk.getSystemClipboard();
  

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    public Object getTransferData(DataFlavor flavor)
            throws UnsupportedFlavorException {
        if (!isDataFlavorSupported(flavor))
            throw new UnsupportedFlavorException(flavor);

        return image;
    }
    public void imageToClipboard(Image img) {
        image = img;
        cb.setContents(this,null);
    }
}
