// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

import gui.run.ObservableSliderBank;

import javax.swing.*;
import java.awt.*;

/**
 * A JInternalFrame containing controls for brightness
 * and contrast adjustment.
 */
public class LinearMappingFrame extends JInternalFrame {
    private ObservableSliderBank sbkLMSliders;
    private JButton btnACL; // automatic contrast control

    /**
     * Create a new LinearMappingFrame
     */
    public LinearMappingFrame() {
        Container c;

        sbkLMSliders = new ObservableSliderBank(2);
        sbkLMSliders.setSliderLabel(0, "Brightness");
        sbkLMSliders.setSliderRange(0, -200f, 200f);
        sbkLMSliders.setTickLabel(0, -200f, "-200");
        sbkLMSliders.setTickLabel(0, 0f, "0");
        sbkLMSliders.setTickLabel(0, 200f, "200");

        sbkLMSliders.setSliderLabel(1, "Contrast");
        sbkLMSliders.setSliderRange(1, 0.2f, 5f);
        sbkLMSliders.setTickLabel(1, 0.2f, "0.2");
        sbkLMSliders.setTickLabel(1, 1f, "1");
        sbkLMSliders.setTickLabel(1, 5f, "5");

        btnACL = new JButton("Auto-adjust");

        c = getContentPane();
        c.setLayout(new BorderLayout());
        c.add(sbkLMSliders, BorderLayout.CENTER);

        JPanel x = new JPanel();
        x.setLayout(new FlowLayout(FlowLayout.RIGHT));
        x.add(btnACL);
        c.add(x, BorderLayout.SOUTH);

        setTitle("Linear Mapping");
        pack();
        setClosable(true);
        setMaximizable(false);
        setResizable(false);
    }

    /**
     * Return a handle to the slider bank on the control panel.
     *
     * @return A reference to an ObservableSliderBank
     */
    public ObservableSliderBank getSliderBank() {
        return sbkLMSliders;
    }

    /**
     * Return a handle to the button on the control panel.
     *
     * @return A reference to a JButton.
     */
    public JButton getButton() {
        return btnACL;
    }
}
