// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

// Standard libraries

import javax.swing.*;
import java.awt.*;

/**
 * This is a panel that displays an image.  It resizes itself to
 * accommodate the underlying image.
 */
public class ImagePanel extends JPanel {
    Image displayedImage = null;
    int intImageHeight = 0;
    int intImageWidth = 0;

    /**
     * Construct a new image panel (not yet containing an image).
     */
    public ImagePanel() {
        setPreferredSize(new Dimension(0, 0));
    }

    /**
     * Override the width reporting so that it's guaranteed to be
     * the width of the underlying image.
     */
    public int getWidth() {
        return intImageWidth;
    }

    /**
     * Override the heigth reporting so that it's guaranteed to be
     * the height of the underlying image.
     */
    public int getHeight() {
        return intImageHeight;
    }

    /**
     * Override the panel's paint method to display the image.
     */
    public void paint(Graphics g) {
        if (displayedImage != null) {
            g.drawImage(displayedImage, 0, 0, this);
        }
    }

    /**
     * Specify the image to be painted on the panel.
     */
    public void setImage(Image img) {
        MediaTracker mt = new MediaTracker(this);

        displayedImage = img;
        mt.addImage(displayedImage, 0);

        // Load the image completely.

        try {
            mt.waitForID(0);
        } catch (InterruptedException e) {
            // do nothing for now if image fails to load.
            return;
        }

        // Get height and width of the new image.  Pass a null
        // ImageObserver to the height and width functions since
        // we know they will return valid values by virtue of
        // using the MediaTracker.

        intImageWidth = displayedImage.getWidth(null);
        intImageHeight = displayedImage.getHeight(null);

        setPreferredSize(new Dimension(intImageWidth, intImageHeight));
        repaint();
    }

    /**
     * Obtain a handle to the image
     */

    public Image getImage() {
        return displayedImage;
    }
}