package j2d.filters;

import ip.transforms.Kernels;
import j2d.ImageProcessorInterface;
import j2d.ImageUtils;
import utils.Timer;

import java.awt.*;


public class GaussianSmoothingProcessor
        implements ImageProcessorInterface {

    private int kernelWidth;
    private double sigma;


    public GaussianSmoothingProcessor(
            int _kernelWidth,
            double _sigma) {

        kernelWidth = _kernelWidth;
        sigma = _sigma;
    }

    public Image process(Image img) {
        Timer t = new Timer();
        t.start();
        Image i = gaussianSmooth(img);
        t.stop();
        double f = t.getElapsedTime();
        System.out.println(
                "did convolution with "
                +kernelWidth
                + "kernel in "
                + f
                +" seconds.");
        return i;

    }

    private Image gaussianSmooth(Image img) {
        return ImageUtils.convolution(img,
                Kernels.getGaussKernel(
                        kernelWidth,
                        kernelWidth,
                        sigma));
    }

}

