package j2d.face;

import futils.Futil;
import gui.In;

import java.io.File;
import java.io.IOException;


public class Main {

    public static void main(String args[]) {
        File dir = Futil.getReadFileDir("select image database folder") ;
        File file = Futil.getReadFile("select suspect") ;
        try {
            faceMatch(dir, file);
        } catch (IOException e) {
            In.message(e);
        } catch (ClassNotFoundException e) {
            In.message(e);
        }
    }

    private static void faceMatch(File dir, File file)
            throws IOException, ClassNotFoundException {
        EigenFaceCreator creator = new EigenFaceCreator();
        utils.Timer t = new utils.Timer();
        t.start();
        //creator.USE_CACHE = -1;
        System.out.println("Constructing face-spaces from " + dir + " ...");
        creator.readFaceBundles(dir);
        t.stop();
        t.report();
        System.out.println("Comparing " + file + " ...");

        String result = creator.checkAgainst(file);
        System.out.println("Most closly reseambling: "
                + result + " with " + creator.DISTANCE + " distance.");
    }



}
