package j2d.edge.gabor;

import gui.run.RunButton;
import gui.run.RunSlider;
import ip.martelli.MartelliParams;

import javax.swing.*;
import java.awt.*;


public class MartelliView {
    MartelliParams mp = null;

    public MartelliView(MartelliParams _mp) {
        mp = _mp;
        init();
    }

    java.awt.Container c = null;

    public void init() {
        gui.ClosableJFrame cf = new gui.ClosableJFrame();
        cf.setSize(200, 200);
        c = cf.getContentPane();
        c.setLayout(new FlowLayout());
        greedSlider(c);
        pixelSlider(c);
        plySlider(c);


        cf.setVisible(true);
    }

    public void addRunButton(RunButton rb) {
        c.add(rb);
    }

    private void plySlider(java.awt.Container c) {
        c.add(new RunSlider(0, 10, mp.getPly()) {
            public void run() {
                mp.setPly(getValue());
            }
        }, BorderLayout.CENTER);
        c.add(new JLabel("Ply"), BorderLayout.WEST);
    }

    private void pixelSlider(java.awt.Container c) {
        c.add(new RunSlider(0, 10, mp.getPixel()) {
            public void run() {
                mp.setGreediness(getValue());
            }
        }, BorderLayout.CENTER);
        c.add(new JLabel("Pixel"), BorderLayout.WEST);
    }

    private void greedSlider(java.awt.Container c) {
        c.add(new RunSlider(0, 10, mp.getGreediness()) {
            public void run() {
                mp.setGreediness(getValue());
            }
        }, BorderLayout.CENTER);
        c.add(new JLabel("Greed"), BorderLayout.WEST);
    }


}