package j2d.edge;

import gui.run.RunButton;
import gui.run.RunCheckBox;
import gui.run.RunSlider;
import j2d.ComparisonUtils;
import j2d.ImageBeanInterface;
import j2d.ImageProcessListener;
import j2d.ImageProcessorFactory;

import javax.swing.*;
import java.awt.*;


public class SobelPanel extends JPanel {


    private int a = 1;
    private boolean isX = true;

    ImageProcessListener ipl = null;

    /**Construct the frame*/
    public SobelPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    /**Component initialization*/
    private void initGuiElements() {
        setLayout(new FlowLayout());

        add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        add(new RunCheckBox() {
            public void run() {
                isX = !isX;
            }
        });
        add(new RunSlider(1, 10, 1) {
            public void run() {
                a = this.getValue();
                updateImage();
            }
        });

        add(new RunButton("comparison") {
            public void run() {
                ImageProcessorFactory ipf =
                        new SobelProcessor(a, isX);
                ComparisonUtils.showComparisonFrame(
                        getComparisonPanel(ipf));
            }
        });
    }

    public JPanel getComparisonPanel(ImageProcessorFactory ipf) {

        ImageBeanInterface origImagePanel = (ImageBeanInterface) ipl;
        Image sourceImage = origImagePanel.getImage();
        return ComparisonUtils.getComparisonPanel(sourceImage, ipf);

    }

    public void updateImage() {
        ipl.update(new SobelProcessor(a, isX));

    }


}
