/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 1, 2003
 * Time: 9:45:14 AM
 */
package j2d.edge;

import j2d.ImageProcessorInterface;
import j2d.ImageUtils;
import math.Mat2;

import java.awt.*;

public class FreiChenProcessor
        implements ImageProcessorInterface {
    public FreiChenProcessor() {
    }

    public Image process(Image img) {
        float r2 = (float) Math.sqrt(2);
        float k1[][] = {
            {1, 0, -1},
            {r2, 0, -r2},
            {1, 0, -1}
        };

        float k2[][] = {
            {-1, -r2, -1},
            {0, 0, 0},
            {1, r2, 1}
        };
        double s = 1 / (2 + r2);
        Mat2.scale(k1, s);
        Mat2.scale(k2, s);
        //printMaple(k1,"k1=");
        //printMaple(k2,"k2=");
        img = ImageUtils.convolution(img, k1);
        img = ImageUtils.convolution(img, k2);

        return ImageUtils.combineBands(2f, 2f, 2f, img);
    }


}
