/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;

import j2d.ImageProcessorInterface;
import j2d.ImageUtils;

import java.awt.*;
import java.awt.image.RGBImageFilter;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 27, 2005
 * <p/>
 * Time: 8:10:56 AM
 */
public abstract class RgbFilterProcessor extends RGBImageFilter
        implements ImageProcessorInterface {
    public RgbFilterProcessor() {
        // When this is set to true, the filter will work with images
        // whose pixels are indices into a color table (IndexColorModel).
        // In such a case, the color values in the color table are filtered.
        canFilterIndexColorModel = true;
    }


    public Image process(Image image){
       return ImageUtils.getImage(image,this);
    }
}
