/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;

import gui.run.RunButton;
import j2d.gui.Main;

import javax.swing.*;
import java.awt.*;

public class RgbFilterPanel
        extends JPanel {


    public RgbFilterPanel(final Main main) {

        setLayout(new GridLayout(0, 3));

        add(new RunButton("get [red") {
            public void run() {
                main.process(new RedFilter());
            }
        });
        add(new RunButton("get [green") {
            public void run() {
                main.process(new GreenFilter());
            }
        });
        add(new RunButton("get [blue") {
            public void run() {
                main.process(new BlueFilter());
            }
        });
        add(new RunButton("GreenBlue[SwapFilter") {
            public void run() {
                main.process(new GreenBlueSwapFilter());
            }
        });
        add(new RunButton("RedBlueS[wapFilter") {
            public void run() {
                main.process(new RedBlueSwapFilter());
            }
        });
        add(new RunButton("RedGreenSwap[Filter") {
            public void run() {
                main.process(new RedGreenSwapFilter());
            }
        });
        add(new RunButton("[invert") {
            public void run() {
                main.process(new InvertFilter());
            }
        });
        add(new RunButton("gr[ey") {
            public void run() {
                main.process(new GreyFilter());
            }
        });
        add(new RunButton("re[vert") {
            public void run() {
                main.revertImage();
            }
        });
        add(new RunButton("[apply") {
            public void run() {
                main.apply();
            }
        });


    }



}
