/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Feb 28, 2003
 * Time: 10:24:09 AM
 */
package j2d.color;

import j2d.hpp.HppFilterInterface;


public class PseudoColorFilter implements
        HppFilterInterface {
    double params[] = {
        0.0125,
        0.125,
        0.425};

    public PseudoColorFilter(double ar, double ag, double ab) {
        params[0] = ar;
        params[1] = ag;
        params[2] = ab;
    }

    public PseudoColorFilter() {
    }

    public short getR(int v) {
        return getFunction(v, params[0]);
    }

    public short getG(int v) {
        return getFunction(v, params[1]);
    }

    public short getB(int v) {
        return getFunction(v, params[2]);
    }

    public static short getFunction(int v, double a) {
        return (short) (255 / 2.0 * (Math.sin(a * v) + 1));
    }
}
