/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.border;

import j2d.ImageUtils;

import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import java.awt.*;
import java.awt.image.renderable.ParameterBlock;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Mar 19, 2005
 * <p/>
 * Time: 5:42:38 AM
 */
public class Utils {
    public static final int BORDER_ZERO = 0;
    public static final int BORDER_CONSTANT = 1;
    public static final int BORDER_COPY = 2;
    public static final int BORDER_REFLECT = 3;
    public static final int BORDER_WRAP = 4;


    public static PlanarImage getBorderImageZero(PlanarImage planarImage,
                                                 int leftValue,
                                                 int rightValue,
                                                 int topValue,
                                                 int bottomValue) {
        return getBorderImage(planarImage,
                leftValue,
                rightValue,
                topValue,
                bottomValue,
                BORDER_ZERO);
    }

    //todo make a nice borderpanel for the MDI processor.
    public static Image getBorderImage(Image img,
                                       int left,
                                       int right,
                                       int top,
                                       int bottom,
                                       int border) {
        return
                ImageUtils.getImage(getBorderImage(ImageUtils.getPlanarImage(img),
                        left, right, top, bottom, border));
    }

    public static PlanarImage getBorderImage(PlanarImage planarImage,
                                             int leftValue,
                                             int rightValue,
                                             int topValue,
                                             int bottomValue,
                                             int borderType) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(planarImage);
        pb.add(new Integer(leftValue));
        pb.add(new Integer(rightValue));
        pb.add(new Integer(topValue));
        pb.add(new Integer(bottomValue));

        switch (borderType) {

            case BORDER_ZERO:
                pb.add(BorderExtender.createInstance(BorderExtender.BORDER_ZERO));
                break;
            case BORDER_CONSTANT: // Construction of constant borders is different.
                pb.add(new BorderExtenderConstant(new double[]{255., 0., 180.}));
                break;
            case BORDER_COPY:
                pb.add(BorderExtender.createInstance(BorderExtender.BORDER_COPY));
                break;
            case BORDER_REFLECT:
                pb.add(BorderExtender.createInstance(BorderExtender.BORDER_REFLECT));
                break;
            case BORDER_WRAP:
                pb.add(BorderExtender.createInstance(BorderExtender.BORDER_WRAP));
                break;
        }
        PlanarImage borderImage = JAI.create("border", pb);
        // Oops, the border will be set "outside" the original image extents,
        // which will cause problems for the display component. Let's reposition
        // it so the image origin is back at (0,0).
        pb = new ParameterBlock();
        pb.addSource(borderImage);
        pb.add(1.0f * leftValue);
        pb.add(1.0f * topValue);
        // Create the output image by translating itself.
        borderImage = JAI.create("translate", pb, null);
        return borderImage;
    }
}
