package ip.apurva;

import ip.gui.frames.ColorFrame;
import j2d.color.Ccir601_2cbcr;
import math.Random;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FourierFrame extends ZipFrame
        implements ActionListener {

    MenuBar mb = getMenuBar();

    Menu Fou_menu = new Menu("Fourier Synthesis");
    MenuItem FouMountain = addMenuItem(Fou_menu,
                                       "Mountain scene");
//MenuItem FouOcean = addMenuItem(Fou_menu,"Ocean");

    public void actionPerformed(ActionEvent e) {
        if (match(e, FouMountain)) {
            fou_mi();
            return;
        }
        super.actionPerformed(e);
    }

    public void fou_mi() {
        initframe();
    }

    public void initframe() {
        //randomise image
        imageRandom();
        //gui.run fast fourier transform on it
        fftR2();
        //mutiply 1/f filter
        Ccir601_2cbcr cc = new Ccir601_2cbcr(
                new ColorFrame("colorframe"));
        cc.fromRgb();
        cc.oneOnF();
        cc.toRgb();
        //gui.run inverse fast fourier transform
        ifftR2();
        //gui.run rd image
        threeDImage();
        short2Image();
    }

    public void imageRandom() {
        for (int i = 0; i <
                        shortImageBean.getR()
                .length; i++) {
            for (int j = 0; j <
                            shortImageBean.getR()[0].length; j++) {
                int s = Random.rand(0, 255);
                shortImageBean.getR()[i][j] += s;
                shortImageBean.getB()[i][j] += s;
                shortImageBean.getG()[i][j] += s;
            }
        }

    }

    public void threeDImage() {

        graphics.ddd.MainFrame.image3D(
                getImage(),
                shortImageBean.getR());
        return;
    }

    public void multOneonF() {
        int xc = getImageWidth() / 2;
        int yc = getImageHeight() / 2;
        for (int x = 0; x < getImageWidth(); x++) {
            for (int y = 0; y < getImageHeight(); y++) {
                double f = oneOnF(x, y, xc, yc);
                shortImageBean.getR()[x][y] =
                (short) (shortImageBean.getR()[x][y] *
                         f);
                shortImageBean.getG()[x][y] =
                (short) (shortImageBean.getG()[x][y] *
                         f);
                shortImageBean.getB()[x][y] =
                (short) (shortImageBean.getB()[x][y] *
                         f);
            }
        }
        short2Image();
    }

    public static double oneOnF(int x,
                                int y,
                                double xc,
                                double yc) {
        double dx = x - xc;
        double dy = y - yc;
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double eps = 1;
        return 1 / Math.sqrt(dx2 + dy2 + eps);
    }

    FourierFrame() {
        mb.add(Fou_menu);
        setMenuBar(mb);
        repaint();
    }

    public static void main(String args[]) {
        new FourierFrame();
    }

}