package gui.run;

import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;


public abstract class RunPasswordField
        extends JPasswordField
        implements ActionListener,
        KeyListener, Runnable {
    String sTxt;

    public RunPasswordField(String text) {
        super(text);
        addActionListener(this);
        addKeyListener(this);
    }

    public void keyTyped(KeyEvent e) {
    };

    public void keyPressed(KeyEvent e) {
    };

    public void keyReleased(KeyEvent e) {
        run();
    };

    public RunPasswordField() {
        addActionListener(this);
        addKeyListener(this);
    }

    public RunPasswordField(int columns) {
        super(columns);
        addActionListener(this);
        addKeyListener(this);
    }

    public RunPasswordField(String text,
                            int columns) {
        super(text, columns);
        addActionListener(this);
        addKeyListener(this);
    }

    public RunPasswordField(javax.swing.text.Document doc,
                            String text,
                            int columns) {
        super(doc, text, columns);
        addActionListener(this);
        addKeyListener(this);
    }

    public String getPasswordString() {
        return new String(super.getPassword());
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        run();
    }

    public static void main(String args[]) {
        gui.ClosableJFrame cf = new gui.ClosableJFrame("RunPasswordField");
        java.awt.Container c = cf.getContentPane();
        c.add(new RunPasswordField("What is your password?") {
            public void run() {
                System.out.println(getPassword());

            }
        });
        c.setLayout(new java.awt.GridLayout(4, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}