/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;


import gui.ClosableJFrame;
import gui.layouts.DialogLayout;

import javax.swing.*;
import java.awt.*;


public abstract class RunLabelPanel
        extends JPanel implements Runnable {

    private LabelBean labelBean = LabelBean.restore();


    public RunLabelPanel() {

        init();
    }

    private void init() {
        setLayout(new BorderLayout());
        add(getLabelMarginPanel(), BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    private JPanel getLabelMarginPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(2, 0));
        jp.add(getLabelPanel());
        jp.add(getMarginPanel());
        return jp;
    }

    private JPanel getLabelPanel() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createTitledBorder("Label Dimensions"));
        jp.add(new JLabel("Number of Labels per Column"));
        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getNumberOfLabelsPerColumn(), 1, 100, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setNumberOfLabelsPerColumn(i);
            }
        });
        jp.add(new JLabel("Number of Labels"));
        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getNumberOfLabels(), 1, 100, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setNumberOfLabels(i);
            }
        });
        jp.add(new JLabel("Vertical Gutter"));
        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getVerticalGutter(), 0, 50, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setVerticalGutter(i);
            }
        });
        jp.add(new JLabel("Horizontal Gutter"));
        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getHorizontalGutter(), 0, 50, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setHorizontalGutter(i);
            }
        });
        jp.setLayout(new DialogLayout());
        return jp;
    }

    private JPanel getMarginPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new DialogLayout());
        jp.setBorder(BorderFactory.createTitledBorder("Margins"));
        jp.add(new JLabel("Left"));

        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getLeftMargin(), 1, 100, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setLeftMargin(i);
            }
        });

        jp.add(new JLabel("Right"));
        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getRightMargin(), 1, 100, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setRightMargin(i);
            }
        });
        jp.add(new JLabel("Top"));
        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getTopMargin(), 1, 100, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setTopMargin(i);
            }
        });
        jp.add(new JLabel("Bottom"));
        jp.add(new RunSpinner(new SpinnerNumberModel(labelBean.getBottomMargin(), 1, 100, 1)) {
            public void run() {
                int i = ((Integer) getValue()).intValue();
                labelBean.setBottomMargin(i);
            }
        });


        return jp;
    }


    public LabelBean getValue() {
        return labelBean;
    }


    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("ok") {
            public void run() {
                RunLabelPanel.this.run();
                labelBean.save();
            }
        });
        return jp;
    }


    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(new RunLabelPanel() {
            public void run() {
                System.out.println(getValue());
            }
        });
        cf.pack();
        cf.setVisible(true);
    }


}