package gui.run;

import utils.SystemUtils;

import java.io.File;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 15, 2004
 * <p/>
 * Time: 5:59:55 AM
 */
public class RunJobUtils {
    public static void main(String[] args) {
        testRunJobFile();
    }

    private static void testRunJobFile() {
        final File f = new File(SystemUtils.getUserDir()
                + SystemUtils.getDirectorySeparator()
                + ".killScreenSaver");
        killJvmIfFileExists(f);
    }

    /**
     * Kill the JVM if the file exists. Great for
     * an asynchronous kill of the present JVM by
     * another JVM. Better make sure you clean up your
     * mess on exit, since this is SUDDEN DEATH.
     * This program has the side-effect of deleting
     * the lock file, on exit.
     *
     * @param f the lock file to signal the kill.
     */
    public static void killJvmIfFileExists(final File f) {
        new RunJob(1) {
            public void run() {
                if (f.exists()) {
                    f.delete();
                    System.exit(0);
                }

            }
        };
    }
}
