package gui.run;

import gui.In;
import utils.StringUtils;

import javax.swing.*;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Apr 20, 2005
 * Time: 7:21:49 PM
 * Copyright DocJava, 2005
 */
class RadioTextPanel extends JPanel {
    private char delimiter = '\t';
    private RunRadio rb1 = new RunRadio("tab") {
        public void run() {
            delimiter = '\t';
        }
    };
    private RunRadio rb2 = new RunRadio("cr") {
        public void run() {
            delimiter = StringUtils.NEW_LINE;
        }
    };
    private final RunTextField tf = new RunTextField(1){
        public void run(){
            setTextField();
        }
    };

    private void setTextField() {
        final String text = tf.getText();
        if (text.length()>1) {
            In.message("A delimiter can only be one char long");
            tf.setText(delimiter+"");
            return;
        }
        delimiter = StringUtils.getFirstChar(text);
    }

    private RunRadio rb3 = new RunRadio("") {
        public void run() {
            setTextField();
        }
    };


    RadioTextPanel( String title) {

        setBorder(BorderFactory.createTitledBorder(title));
        add(rb1);
        add(rb2);
        add(rb3);
        add(tf);
        ButtonGroup bg = new ButtonGroup();
        bg.add(rb1);
        bg.add(rb2);
        bg.add(rb3);
    }

    public char getDelimiter() {
        return delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        tf.setText(""+delimiter);
        if (delimiter =='\t') {
            rb1.setSelected(true);
            return;
        }
        if (delimiter ==StringUtils.NEW_LINE) {
            rb2.setSelected(true);
            return;
        }
        rb3.setSelected(true);
    }
}
