/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;


public class MouseCheckBoxPanel extends
                                          JPanel {
    private JCheckBox rcb[][];

    public MouseCheckBoxPanel(int w) {
        rcb = new JCheckBox[w][w];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < w; y++) {
                final JCheckBox cb = new JCheckBox();
                add(cb);
                rcb[x][y] = cb;

                cb.addMouseListener(getCheckBoxListener(cb));
            }
        setLayout(new GridLayout(w, 0,0,0));
        super.setToolTipText("alt turns on, control turns off");
    }
    public void setBackground(Color c){
        if (rcb == null) return;
        for (int i=0; i < rcb.length; i++)
            for (int j=0; j < rcb[0].length;j++)
                rcb[i][j].setBackground(c);
        super.setBackground(c);
    }
    public JCheckBox [][] getValue(){
        return rcb;
    }

    private MouseListener getCheckBoxListener(final JCheckBox cb) {
        return new MouseListener(){
                            public void mouseClicked(MouseEvent event){}

                            public void mousePressed(MouseEvent event) {
                            }

                            public void mouseReleased(MouseEvent event) {
                            }

                            public void mouseEntered(MouseEvent event) {
                                if (event.isAltDown())
                                    cb.setSelected(true);
                                else if (event.isControlDown())
                                    cb.setSelected(false);
                            }

                            public void mouseExited(MouseEvent event) {


                            }
                        };
    }


    public static void main(String[] args) {
        testRunCheckBox();
    }

    public static void testRunCheckBox() {
        ClosableJFrame cf = new ClosableJFrame("RunCheckBox");
        Container c = cf.getContentPane();
        c.add(new MouseCheckBoxPanel(5));
        c.add(
                new RunButton("ok") {
                    public void run() {
                        System.out.println("ok");
                    }
                });
        c.setLayout(new FlowLayout());

        cf.pack();
        cf.setVisible(true);

    }
}