package gui.run;

/*
      @(#)LogFloatLabelJSlider.java 1.2 01/08/01 11:02:20

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import j3d.utils.Java3DExplorerConstants;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;


public class LogFloatLabelJSlider extends JPanel implements ChangeListener,
                                                            Java3DExplorerConstants {

    JSlider slider;
    JLabel valueLabel;
    Vector listeners = new Vector();
    float min, max, resolution, current, scale;
    double minLog, maxLog, curLog;
    int minInt, maxInt, curInt;;
    int intDigits, fractDigits;
    NumberFormat nf = NumberFormat.getInstance();
    float minResolution = 0.001f;
    double logBase = Math.log(10);

    // default slider with name, resolution = 0.1, min = 0.0, max = 1.0 inital
    // 0.5
    public LogFloatLabelJSlider(String name) {
        this(name, 0.1f, 100.0f, 10.0f);
    }

    public LogFloatLabelJSlider(String name, float min, float max, float current) {

        this.resolution = resolution;
        this.min = min;
        this.max = max;
        this.current = current;

        if (resolution < minResolution) {
            resolution = minResolution;
        }


        minLog = log10(min);
        maxLog = log10(max);
        curLog = log10(current);

        // resolution is 100 steps from min to max
        scale = 100.0f;
        resolution = 1.0f / scale;

        // get the integer versions of max, min, current
        minInt = (int) Math.round(minLog * scale);
        maxInt = (int) Math.round(maxLog * scale);
        curInt = (int) Math.round(curLog * scale);

        slider = new JSlider(JSlider.HORIZONTAL, minInt, maxInt, curInt);
        slider.addChangeListener(this);

        valueLabel = new JLabel(" ");

        // Need to muck around to make sure that the width of the label
        // is wide enough for the largest value.  Pad the initial string
        // be large enough to hold the largest value.
        int pad = 5;  // fudge to make up for variable width fonts
        intDigits = (int) Math.ceil(maxLog) + pad;
        if (min < 0) {
            intDigits++; // add one for the '-'
        }
        if (minLog < 0) {
            fractDigits = (int) Math.ceil(-minLog);
        } else {
            fractDigits = 0;
        }
        nf.setMinimumFractionDigits(fractDigits);
        nf.setMaximumFractionDigits(fractDigits);
        String value = nf.format(current);
        while (value.length() < (intDigits + fractDigits)) {
            value = value + " ";
        }
        valueLabel.setText(value);

        // add min and max labels to the slider
        Hashtable labelTable = new Hashtable();
        labelTable.put(new Integer(minInt),
                new JLabel(nf.format(min)));
        labelTable.put(new Integer(maxInt),
                new JLabel(nf.format(max)));
        slider.setLabelTable(labelTable);
        slider.setPaintLabels(true);


        // layout to align left
        setLayout(new BorderLayout());
        Box box = new Box(BoxLayout.X_AXIS);
        add(box, BorderLayout.WEST);

        box.add(new JLabel(name));
        box.add(slider);
        box.add(valueLabel);
    }

    public void setMinorTickSpacing(float spacing) {
        int intSpacing = Math.round(spacing * scale);
        slider.setMinorTickSpacing(intSpacing);
    }

    public void setMajorTickSpacing(float spacing) {
        int intSpacing = Math.round(spacing * scale);
        slider.setMajorTickSpacing(intSpacing);
    }

    public void setPaintTicks(boolean paint) {
        slider.setPaintTicks(paint);
    }

    public void addFloatListener(FloatListener listener) {
        listeners.add(listener);
    }

    public void removeFloatListener(FloatListener listener) {
        listeners.remove(listener);
    }


    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider) e.getSource();
        curInt = source.getValue();
        curLog = curInt / scale;
        current = (float) exp10(curLog);

        valueChanged();
    }

    public void setValue(float newValue) {
        boolean changed = (newValue != current);
        current = newValue;
        if (changed) {
            valueChanged();
        }
    }


    private void valueChanged() {
        String value = nf.format(current);
        valueLabel.setText(value);

        // notify the listeners
        FloatEvent event = new FloatEvent(this, current);
        for (Enumeration e = listeners.elements(); e.hasMoreElements();) {
            FloatListener listener = (FloatListener) e.nextElement();
            listener.floatChanged(event);
        }
    }

    double log10(double value) {
        return Math.log(value) / logBase;
    }

    double exp10(double value) {
        return Math.exp(value * logBase);
    }


}
