package gui.keyboard;

import gui.run.RunButton;
import gui.run.RunTextField;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;


public class QwertyKeyboard {
    static class TextModel {
        private String s = "";
        private RunTextField readOut;


        public void setReadOut(
                RunTextField _readOut) {
            readOut = _readOut;
        }

        public void ScreenKey(String _s) {
            s = s + _s;
            updateReadOut();
        }

        public void setState(String _s) {
            s = _s;
        }

        public void updateReadOut() {
            if (readOut == null) return;
            readOut.setText(s);
        }

        public String getS() {
            return s;
        }

        public void setS(String s) {
            this.s = s;
        }

        public RunTextField getReadOut() {
            return readOut;
        }
    }

    class ButtonListener
            implements ActionListener {
        public void actionPerformed(
                ActionEvent e) {
            Object o = e.getSource();
            if (o instanceof JButton) {
                JButton jb = (JButton) o;
                QwertyKeyboard.tm.ScreenKey(
                        jb.getText());
            }
        }
    }

    class ButtonFrame extends JFrame {
        Vector buttonList = new Vector();

        ButtonFrame() {
            Container c = this.getContentPane();
            c.setLayout(new GridLayout(5, 13));
            setSize(200, 200);
            setVisible(true);
        }

        private boolean isUpper = false;

        public void addButton(Container c,
                              char ch,
                              ButtonListener bc) {
            JButton b = new JButton(ch + "");
            b.addActionListener(bc);
            c.add(b);
            buttonList.addElement(b);
        }

        char[] specArray = {0, 1, 2, 3, 4, 5, 6,
                            7, 8, 9, 10, 11, 12,
                            23, 24, 25, 35, 36,
                            44, 45, 46};
        boolean special = false;

        public void upcaseButtons() {

            for (int i = 0; i <
                            buttonList.size() -
                            1; i++) {
                RunButton rb = (RunButton) buttonList.elementAt(
                        i);
                String s = rb.getText();
                for (int x = 0; x <
                                specArray.length; x++) {
                    // determines if it is non-letter button
                    if (i == (int) specArray[x])
                        special = true;
                }
                if (isUpper) {
                    if (special) {
                        rb.setText(
                                down.substring(i,
                                               i +
                                               1));
                    } else {
                        rb.setText(
                                s.toLowerCase());
                    }
                } else {
                    if (special) {
                        rb.setText(up.substring(
                                i,
                                i +
                                1));
                    } else {
                        rb.setText(
                                s.toUpperCase());
                    }

                }
                special = false;
            }
            if (isUpper)
                isUpper = false;
            else
                isUpper = true;
        }


        public void addButton(JPanel p,
                              char ch,
                              ButtonListener bc) {
            RunButton b = new RunButton("[" + ch) {
                public void run() {

                }

                public Dimension getPreferredSize() {
                    return new Dimension(20, 20);
                }
            };

            b.addActionListener(bc);
            p.add(b);
            buttonList.addElement(b);
        }

    }

    ButtonFrame bf = new ButtonFrame();
    ButtonListener bc = new ButtonListener();
    Container c = bf.getContentPane();

    JPanel FKeys = new JPanel();
    JPanel Letters = new JPanel();
    JPanel numbers = new JPanel();
    JPanel p = new JPanel();
    public static JPanel j = new JPanel();

    String down = "`1234567890-=qwertyuiop[]\\asdfghjkl;'zxcvbnm,./";
    String up = "~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?";

    public static String st = "What is your name?";

    static TextModel tm = new TextModel();
    RunTextField textView = new RunTextField() {
        public void run() {
            tm.setState(getText());
            System.out.println(
                    "getText=" + getText());
        }
    };

    public String getUppercase() {
        return down.toUpperCase();
    }

    public JPanel addRow(char ca[],
                         int min,
                         int max) {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        for (int x = min; x < max; x++)
            bf.addButton(p, ca[x], bc);
        p.invalidate();
        return p;
    }

    QwertyKeyboard() {
        char ca[] = down.toCharArray();

        JPanel keypadPanel = new JPanel();
        keypadPanel.setLayout(new FlowLayout());
        keypadPanel.add(addRow(ca, 0, 13));
        keypadPanel.add(addRow(ca, 13, 26));
        keypadPanel.add(addRow(ca, 26, 37));
        keypadPanel.add(
                addRow(ca, 37, ca.length));
        keypadPanel.add(new RunButton(
                "shift lock") {
            public void run() {
                bf.upcaseButtons();
            }
        });

        bf.addButton(c, ' ', bc);
        tm.setReadOut(textView);

        c.setLayout(new BorderLayout());
        c.add(textView, BorderLayout.NORTH);
        c.add(keypadPanel, BorderLayout.CENTER);

        bf.setSize(650, 300);
        bf.setVisible(true);
        bf.invalidate();
    }

    public static void main(String args[]) {
        new QwertyKeyboard();
    }
}
